# 📱 Panduan Penggunaan POS Offline Mode

## 🎯 Overview

Sistem POS sekarang mendukung **offline mode** - Anda dapat membuat transaksi meskipun internet mati. Transaksi akan tersimpan secara lokal dan disinkronkan otomatis saat internet kembali.

## 🚀 Instalasi sebagai PWA

### **Desktop (Chrome/Edge):**
1. Buka aplikasi POS di browser
2. Klik ikon **"Install"** di address bar (atau menu > Install)
3. Aplikasi akan terinstall dan bisa dibuka seperti aplikasi desktop

### **Mobile (Android Chrome):**
1. Buka aplikasi POS di browser
2. Pilih menu (3 titik) > **"Add to Home Screen"**
3. Aplikasi akan muncul di home screen seperti aplikasi native

### **Mobile (iOS Safari):**
1. Buka aplikasi POS di Safari
2. Klik tombol **Share** (kotak dengan panah)
3. Pilih **"Add to Home Screen"**
4. Aplikasi akan muncul di home screen

## 💡 Cara Menggunakan Offline Mode

### **1. Saat Online (Normal):**
- Buka aplikasi seperti biasa
- Buat transaksi, data langsung tersimpan ke server
- Semua fitur berfungsi normal

### **2. Saat Offline (Internet Mati):**

#### **Indikator Status:**
- **Bar hijau di atas**: Status "Online" 
- **Bar orange di atas**: Status "Offline" (berkedip)
- **Info sync**: Menampilkan jumlah transaksi yang menunggu sinkronisasi

#### **Membuat Transaksi Offline:**
1. Buka aplikasi (akan load dari cache)
2. Pilih produk dan tambahkan ke keranjang
3. Isi form pembayaran
4. Klik **"Proses"**
5. Transaksi akan tersimpan secara lokal
6. Muncul notifikasi: **"Transaksi berhasil disimpan secara offline!"**

#### **Catatan Penting:**
- ✅ Transaksi tetap bisa dibuat
- ✅ Perhitungan total, pajak, diskon tetap berfungsi
- ✅ Produk dan kategori tersedia (dari snapshot terakhir)
- ⚠️ Stok mungkin tidak akurat (menggunakan snapshot)
- ⚠️ Laporan menunggu sinkronisasi

### **3. Sinkronisasi Otomatis:**

Saat internet kembali:
1. **Sync Engine** akan otomatis mendeteksi koneksi
2. Transaksi pending akan dikirim ke server
3. Status bar akan menampilkan progress
4. Notifikasi muncul saat selesai

### **4. Sinkronisasi Manual:**

Jika perlu sync manual:
1. Pastikan internet sudah kembali
2. Klik tombol **"Sync"** di status bar
3. Tunggu hingga proses selesai

## 📊 Status Indicator

### **Status Bar (di atas halaman):**

| Status | Warna | Arti |
|--------|-------|------|
| **Online** | Hijau | Koneksi internet aktif |
| **Offline** | Orange (berkedip) | Tidak ada koneksi internet |
| **Menyinkronkan...** | Hijau + Progress | Sedang sync transaksi |
| **Gagal Sync** | Orange + Error | Beberapa transaksi gagal sync |

### **Info Sync:**
- **"X transaksi menunggu sinkronisasi"**: Ada transaksi yang belum sync
- **"Menyinkronkan X transaksi..."**: Sedang proses sync
- **"Gagal sinkronisasi X transaksi"**: Ada yang gagal, klik "Coba Lagi"

## ⚠️ Batasan Mode Offline

### **✅ Yang BISA dilakukan:**
- Membuat transaksi baru
- Menambah/mengurangi item di cart
- Menghitung total, pajak, diskon
- Melihat produk dan kategori (dari snapshot)
- Menyimpan transaksi ke database lokal

### **❌ Yang TIDAK BISA:**
- Update stok real-time (menggunakan snapshot)
- Laporan real-time (menunggu sync)
- Edit transaksi yang sudah dibuat
- Hapus transaksi (append-only)
- Update produk/kategori (read-only)

### **⚠️ Catatan Penting:**
1. **Stok**: Menggunakan snapshot saat offline, mungkin tidak 100% akurat
2. **Laporan**: Data terbaru menunggu sinkronisasi
3. **Transaksi**: Tidak bisa di-edit setelah dibuat (append-only)
4. **Sync**: Pastikan sync berhasil sebelum tutup aplikasi

## 🔧 Troubleshooting

### **Problem: Transaksi tidak tersimpan offline**

**Solusi:**
1. Cek browser support IndexedDB (Chrome, Firefox, Safari modern)
2. Cek console browser untuk error
3. Pastikan Service Worker sudah terdaftar
4. Clear cache dan reload

### **Problem: Sync tidak berjalan**

**Solusi:**
1. Pastikan internet sudah kembali
2. Klik tombol "Sync" manual
3. Cek console untuk error
4. Pastikan API endpoint `/api/sync-transaction.php` accessible

### **Problem: Produk tidak muncul saat offline**

**Solusi:**
1. Pastikan sudah pernah buka aplikasi saat online (untuk download snapshot)
2. Reload halaman
3. Cek IndexedDB di DevTools > Application

### **Problem: Service Worker tidak terdaftar**

**Solusi:**
1. Pastikan menggunakan HTTPS atau localhost
2. Clear cache dan reload
3. Cek console untuk error
4. Pastikan file `sw.js` accessible

## 📱 Browser Support

### **Full Support:**
- ✅ Chrome/Edge (Desktop & Mobile)
- ✅ Firefox (Desktop & Mobile)
- ✅ Safari (iOS 11.3+)
- ✅ Samsung Internet

### **Partial Support:**
- ⚠️ Safari Desktop (beberapa fitur PWA terbatas)
- ⚠️ Opera (mirip Chrome)

### **Not Supported:**
- ❌ Internet Explorer (tidak support Service Worker)

## 🔐 Keamanan

1. **Data Lokal**: Disimpan di IndexedDB browser (hanya device tersebut)
2. **Sync**: Menggunakan session login yang sama
3. **API**: Validasi di server untuk mencegah abuse
4. **Idempotent**: Transaksi tidak akan duplikat meskipun sync berkali-kali

## 📞 Support

Jika mengalami masalah:
1. Cek console browser (F12) untuk error
2. Screenshot error message
3. Hubungi administrator dengan detail error

---

**Selamat menggunakan POS Offline Mode! 🎉**

