# POS Coffee Shop Application

Aplikasi Point of Sale (POS) berbasis web untuk Coffee Shop, Restoran, dan Warung Kopi.

## Fitur

- ✅ Sistem Autentikasi dengan Role-based Access Control (Admin, Manager, Cashier)
- ✅ Dashboard dengan statistik penjualan
- ✅ Manajemen Produk dan Kategori
- ✅ Interface POS yang intuitif dengan keranjang belanja
- ✅ Sistem Transaksi dengan invoice generation
- ✅ Laporan penjualan harian/bulanan
- ✅ Manajemen Pengguna (Admin only)
- ✅ Cetak struk/nota transaksi
- ✅ UI/UX modern dan responsif
- ✅ Keamanan dengan prepared statements, password hashing, XSS protection

## Requirement

- PHP 7.4 atau lebih tinggi
- MySQL/MariaDB
- Apache dengan mod_rewrite
- XAMPP/WAMP/LAMP

## Instalasi

1. **Clone atau extract aplikasi ke folder htdocs**
   ```
   C:\xampp\htdocs\pos (Windows)
   /Applications/XAMPP/xamppfiles/htdocs/pos (Mac)
   /var/www/html/pos (Linux)
   ```

2. **Setup Database**
   
   **Opsi 1: Menggunakan setup.php (Recommended)**
   - Buka browser dan akses: `http://localhost/pos/config/setup.php`
   - Script akan membuat database dan tabel secara otomatis
   - Default admin user akan dibuat:
     - Username: `admin`
     - Password: `admin123`

   **Opsi 2: Manual SQL**
   - Buat database `pos_coffee` di phpMyAdmin
   - Import file `database.sql`
   - Jalankan query untuk update password admin:
     ```sql
     UPDATE users SET password = SHA2(CONCAT('admin123', 'pos_salt_2024'), 256) WHERE username = 'admin';
     ```

3. **Konfigurasi Database**
   
   Edit file `config/database.php` jika perlu:
   ```php
   private $host = 'localhost';
   private $db_name = 'pos_coffee';
   private $username = 'root';
   private $password = '';
   ```

4. **Konfigurasi Base URL**
   
   Edit file `config/config.php` jika aplikasi tidak di root:
   ```php
   define('BASE_URL', 'http://localhost/pos/');
   ```

5. **Akses Aplikasi**
   - Buka browser: `http://localhost/pos/`
   - Login dengan username: `admin`, password: `admin123`

## Struktur Folder

```
pos/
├── app/
│   └── classes/          # Class PHP (Auth, Product, Category, Transaction)
├── config/               # Konfigurasi (database, config, functions)
├── public/               # File yang diakses publik
│   ├── assets/          # CSS, JS, images
│   ├── includes/        # Header, Footer
│   ├── dashboard.php    # Dashboard
│   ├── pos.php          # Interface POS
│   ├── products.php     # Manajemen Produk
│   ├── categories.php   # Manajemen Kategori
│   ├── transactions.php # Daftar Transaksi
│   ├── reports.php      # Laporan
│   └── users.php        # Manajemen User
├── database.sql         # Schema database
└── README.md           # Dokumentasi
```

## Keamanan

- ✅ Password hashing dengan SHA-256 + salt
- ✅ Prepared statements untuk mencegah SQL Injection
- ✅ XSS protection dengan htmlspecialchars
- ✅ Session security (httponly, secure cookies)
- ✅ Role-based access control
- ✅ File .htaccess untuk proteksi direktori

## Roles & Permissions

- **Admin**: Full access (semua fitur termasuk manajemen user)
- **Manager**: Access ke produk, kategori, laporan (tidak bisa manage user)
- **Cashier**: Akses POS dan transaksi
- **Waiters**: Akses dashboard dan transaksi (tidak bisa akses POS)
- **Dapur**: Akses dashboard dan transaksi (untuk melihat order)

## Default Data

Setelah setup, aplikasi sudah include:
- 4 Kategori produk (Minuman Panas, Minuman Dingin, Makanan, Kue & Dessert)
- 14 Sample produk dengan harga dan stok
- 3 Default users:
  - **Admin**: admin / admin123
  - **Waiters**: waiters / waiters123
  - **Dapur**: dapur / dapur123

## Support

Untuk pertanyaan atau issue, silakan buat issue di repository atau hubungi developer.

## License

MIT License - Free to use and modify

