# Panduan Sistem Manajemen Meja

## Fitur Utama

Sistem manajemen meja memungkinkan Anda untuk:
1. **Mengelola meja** - Tambah, edit, hapus, dan ubah status meja
2. **Melacak status meja** - Lihat meja mana yang kosong, terisi, dipesan, atau sedang dibersihkan
3. **Mengaitkan transaksi dengan meja** - Setiap transaksi dapat dikaitkan dengan meja tertentu
4. **Mengantarkan pesanan** - Waiter dapat melihat pesanan siap diantar ke meja tertentu
5. **Monitoring real-time** - Status meja dan pesanan diperbarui secara real-time

## Instalasi

### 1. Jalankan Migration Database

Akses file `update_tables.php` melalui browser:
```
http://localhost/pos/update_tables.php
```

Script ini akan:
- Membuat tabel `tables` untuk menyimpan data meja
- Menambahkan kolom `table_id` ke tabel `transactions`
- Menambahkan 8 meja contoh

### 2. Struktur Database

**Tabel `tables`:**
- `id` - ID meja
- `name` - Nama meja (contoh: "Meja 1")
- `capacity` - Kapasitas meja (jumlah orang)
- `status` - Status meja (available, occupied, reserved, cleaning)
- `location` - Lokasi meja (contoh: "Area Depan")
- `notes` - Catatan tambahan
- `created_at`, `updated_at` - Timestamp

**Tabel `transactions`:**
- `table_id` - ID meja (nullable, untuk take away bisa NULL)

## Penggunaan

### Untuk Manager/Admin

1. **Kelola Meja** (`/public/tables.php`)
   - Tambah meja baru
   - Edit informasi meja (nama, kapasitas, lokasi)
   - Ubah status meja
   - Hapus meja (jika tidak ada transaksi aktif)

2. **Status Meja:**
   - **Kosong (Available)** - Meja siap digunakan
   - **Terisi (Occupied)** - Meja sedang digunakan
   - **Dipesan (Reserved)** - Meja dipesan untuk nanti
   - **Bersihkan (Cleaning)** - Meja sedang dibersihkan

### Untuk Cashier

1. **POS dengan Meja** (`/public/pos.php`)
   - Saat checkout, pilih meja dari dropdown
   - Jika tidak memilih meja, transaksi akan menjadi "Take Away"
   - Meja otomatis berubah status menjadi "Terisi" saat transaksi dibuat

### Untuk Dapur

1. **Kitchen View** (`/public/kitchen.php`)
   - Melihat informasi meja pada setiap order
   - Mengetahui pesanan untuk dine-in atau take away
   - Memudahkan prioritas pengolahan pesanan

### Untuk Waiter

1. **Waiter View** (`/public/waiter.php`)
   - **Pesanan Siap Diantar**: Melihat daftar meja dengan pesanan yang sudah siap
   - **Status Semua Meja**: Melihat status semua meja dan order aktif
   - **Tandai Terkirim**: Menandai item yang sudah diantar ke meja
   - **Update Status Meja**: Mengubah status meja (kosong/terisi/dipesan/bersihkan)

## Workflow

### Dine-In Flow:
1. Customer datang → Cashier pilih meja di POS → Checkout
2. Meja otomatis menjadi "Terisi"
3. Order masuk ke Dapur → Dapur melihat nomor meja
4. Dapur selesaikan order → Status item menjadi "Siap"
5. Waiter melihat di "Pesanan Siap Diantar" → Antar ke meja
6. Waiter tandai "Terkirim" → Status item menjadi "Selesai"
7. Customer selesai → Waiter ubah status meja menjadi "Kosong" atau "Bersihkan"

### Take Away Flow:
1. Customer order → Cashier tidak pilih meja → Checkout
2. Order masuk ke Dapur → Dapur melihat "Take Away"
3. Dapur selesaikan order → Status item menjadi "Siap"
4. Waiter atau Cashier ambil order → Tandai "Terkirim"

## Fitur Tambahan

- **Auto-refresh**: Halaman Waiter dan Dapur auto-refresh setiap 30 detik
- **Visual Status**: Warna berbeda untuk setiap status meja
- **Real-time Updates**: Status meja dan pesanan diperbarui secara real-time
- **History**: Setiap meja mencatat jumlah transaksi per hari

## File yang Ditambahkan/Dimodifikasi

### File Baru:
- `app/classes/Table.php` - Class untuk mengelola meja
- `public/tables.php` - Halaman manajemen meja
- `public/waiter.php` - Halaman waiter view
- `database_tables.sql` - SQL migration
- `update_tables.php` - Script update database

### File yang Dimodifikasi:
- `app/classes/Transaction.php` - Menambahkan dukungan table_id
- `public/pos.php` - Menambahkan pilihan meja saat checkout
- `public/kitchen.php` - Menampilkan informasi meja
- `public/transaction_detail.php` - Menampilkan informasi meja di receipt
- `public/includes/header.php` - Menambahkan link navigasi

## Troubleshooting

### Meja tidak muncul di POS
- Pastikan meja memiliki status "available"
- Cek apakah migration sudah dijalankan

### Error foreign key constraint
- Pastikan tabel `tables` sudah dibuat sebelum menambahkan kolom `table_id`
- Jalankan `update_tables.php` lagi

### Status meja tidak berubah
- Pastikan user memiliki permission yang sesuai
- Cek apakah ada transaksi aktif pada meja tersebut






