<?php
/**
 * Category Class
 * Handles category operations
 */

class Category {
    private $db;
    
    public function __construct() {
        $database = new Database();
        $this->db = $database->getConnection();
    }
    
    /**
     * Get all categories
     */
    public function getAll() {
        $stmt = $this->db->prepare("SELECT * FROM categories WHERE status = 'active' ORDER BY name");
        $stmt->execute();
        $result = $stmt->get_result();
        $categories = [];
        while ($row = $result->fetch_assoc()) {
            $categories[] = $row;
        }
        return $categories;
    }
    
    /**
     * Get category by ID
     */
    public function getById($id) {
        $stmt = $this->db->prepare("SELECT * FROM categories WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();
        return $result->fetch_assoc();
    }
    
    /**
     * Create category
     */
    public function create($name, $description = '') {
        $stmt = $this->db->prepare("INSERT INTO categories (name, description, status) VALUES (?, ?, 'active')");
        $stmt->bind_param("ss", $name, $description);
        return $stmt->execute();
    }
    
    /**
     * Update category
     */
    public function update($id, $name, $description = '') {
        $stmt = $this->db->prepare("UPDATE categories SET name = ?, description = ? WHERE id = ?");
        $stmt->bind_param("ssi", $name, $description, $id);
        return $stmt->execute();
    }
    
    /**
     * Delete category (soft delete)
     */
    public function delete($id) {
        $stmt = $this->db->prepare("UPDATE categories SET status = 'inactive' WHERE id = ?");
        $stmt->bind_param("i", $id);
        return $stmt->execute();
    }
}
?>






