<?php
/**
 * Check Database Structure
 * Check if database ENUM supports waiters and dapur roles
 */

$host = 'localhost';
$username = 'root';
$password = '';
$db_name = 'pos_coffee';

$conn = new mysqli($host, $username, $password, $db_name);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

echo "<!DOCTYPE html>
<html>
<head>
    <meta charset='UTF-8'>
    <title>Database Check</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 800px; margin: 50px auto; padding: 20px; }
        .success { background: #d4edda; border: 1px solid #c3e6cb; color: #155724; padding: 15px; border-radius: 5px; margin: 10px 0; }
        .error { background: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; padding: 15px; border-radius: 5px; margin: 10px 0; }
        .info { background: #d1ecf1; border: 1px solid #bee5eb; color: #0c5460; padding: 15px; border-radius: 5px; margin: 10px 0; }
        .btn { display: inline-block; padding: 10px 20px; background: #007bff; color: white; text-decoration: none; border-radius: 5px; margin-top: 10px; }
        .btn:hover { background: #0056b3; }
        code { background: #f4f4f4; padding: 2px 6px; border-radius: 3px; }
    </style>
</head>
<body>
    <h1>Database Structure Check</h1>";

// Check role ENUM
$sql = "SHOW COLUMNS FROM users WHERE Field = 'role'";
$result = $conn->query($sql);

if ($result && $row = $result->fetch_assoc()) {
    $enum_type = $row['Type'];
    echo "<div class='info'>";
    echo "<h3>Current Role ENUM:</h3>";
    echo "<code>" . htmlspecialchars($enum_type) . "</code>";
    echo "</div>";
    
    if (strpos($enum_type, 'waiters') !== false && strpos($enum_type, 'dapur') !== false) {
        echo "<div class='success'>";
        echo "<strong>✓ Database sudah support role waiters dan dapur</strong>";
        echo "</div>";
    } else {
        echo "<div class='error'>";
        echo "<strong>✗ Database BELUM support role waiters dan dapur!</strong>";
        echo "<p>Silakan jalankan <a href='update_database.php'><strong>update_database.php</strong></a> untuk memperbarui struktur database.</p>";
        echo "</div>";
    }
} else {
    echo "<div class='error'>";
    echo "Error checking database structure: " . $conn->error;
    echo "</div>";
}

// Check existing users
echo "<hr><h2>Existing Users:</h2>";
$sql = "SELECT id, username, name, role, status FROM users ORDER BY id";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    echo "<table border='1' cellpadding='10' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr><th>ID</th><th>Username</th><th>Name</th><th>Role</th><th>Status</th></tr>";
    while ($user = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $user['id'] . "</td>";
        echo "<td><strong>" . htmlspecialchars($user['username']) . "</strong></td>";
        echo "<td>" . htmlspecialchars($user['name']) . "</td>";
        echo "<td><code>" . htmlspecialchars($user['role']) . "</code></td>";
        echo "<td>" . htmlspecialchars($user['status']) . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p>No users found.</p>";
}

$conn->close();

echo "<hr>";
echo "<p><a href='update_database.php' class='btn'>Update Database</a> ";
echo "<a href='public/users.php' class='btn'>Go to User Management</a></p>";
echo "</body></html>";
?>






