<?php
/**
 * Auto-check migrations on application start
 * Include this in config.php or index.php
 */

// Don't require config.php here to avoid circular dependency
require_once __DIR__ . '/database.php';
require_once __DIR__ . '/../app/classes/Migrator.php';

// Only check, don't auto-run (for security)
function checkMigrations() {
    try {
        $migrator = new Migrator();
        $status = $migrator->getStatus();
        
        // Store in session for display
        if (session_status() === PHP_SESSION_ACTIVE) {
            $_SESSION['migration_status'] = $status;
        }
        
        return $status;
    } catch (Exception $e) {
        // Silently fail - migrations might not be critical for app startup
        error_log("Migration check failed: " . $e->getMessage());
        return null;
    }
}

// Auto-check on include (optional - can be disabled)
if (defined('AUTO_CHECK_MIGRATIONS') && AUTO_CHECK_MIGRATIONS === true) {
    checkMigrations();
}

