<?php
/**
 * Application Configuration
 */

// Error reporting (disable in production)
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

// Session security settings
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_secure', 0); // Set to 1 if using HTTPS

// Timezone
date_default_timezone_set('Asia/Jakarta');

// Base URL
define('BASE_URL', 'http://localhost/pos/');
define('BASE_PATH', dirname(__DIR__));

// Directories
define('APP_PATH', BASE_PATH . '/app');
define('PUBLIC_PATH', BASE_PATH . '/public');
define('CONFIG_PATH', BASE_PATH . '/config');

// Application settings
define('APP_NAME', 'POS Coffee Shop');
define('APP_VERSION', '1.0.0');

// Security
define('HASH_ALGO', 'sha256');
define('SESSION_LIFETIME', 3600); // 1 hour

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Auto-load classes
spl_autoload_register(function ($class) {
    $file = APP_PATH . '/classes/' . $class . '.php';
    if (file_exists($file)) {
        require_once $file;
    }
});

// Include database
require_once CONFIG_PATH . '/database.php';
?>






