-- Add payment_status field to transactions table
-- This allows transactions to be created without immediate payment

ALTER TABLE transactions 
ADD COLUMN IF NOT EXISTS payment_status ENUM('unpaid', 'paid') DEFAULT 'paid' AFTER status;

-- Update existing transactions to be marked as paid (backward compatibility)
UPDATE transactions SET payment_status = 'paid' WHERE payment_status IS NULL OR payment_status = '';

-- Add paid_at timestamp to track when payment was completed
ALTER TABLE transactions 
ADD COLUMN IF NOT EXISTS paid_at DATETIME NULL AFTER payment_status;

-- Update existing paid transactions to have paid_at = created_at
UPDATE transactions SET paid_at = created_at WHERE payment_status = 'paid' AND paid_at IS NULL;






