-- Database Update Script
-- Run this if you already have an existing database and want to add waiters and dapur roles

USE pos_coffee;

-- Update users table to add new roles
ALTER TABLE users MODIFY COLUMN role ENUM('admin', 'manager', 'cashier', 'waiters', 'dapur') DEFAULT 'cashier';

-- Insert default waiters user (password: waiters123)
-- Password hash: SHA256('waiters123' + 'pos_salt_2024')
INSERT INTO users (username, password, name, role) 
VALUES ('waiters', 'a1b2c3d4e5f6...', 'Waiter 1', 'waiters')
ON DUPLICATE KEY UPDATE username = username;

-- Insert default dapur user (password: dapur123)
-- Password hash: SHA256('dapur123' + 'pos_salt_2024')
INSERT INTO users (username, password, name, role) 
VALUES ('dapur', 'a1b2c3d4e5f6...', 'Staff Dapur', 'dapur')
ON DUPLICATE KEY UPDATE username = username;

-- Note: You should run setup.php instead, as it will properly hash the passwords






