-- Update Database Schema untuk Status Item
-- Run this to add status field to transaction_items table

USE pos_coffee;

-- Add status column if not exists
ALTER TABLE transaction_items 
ADD COLUMN IF NOT EXISTS status ENUM('pending', 'preparing', 'ready', 'completed') DEFAULT 'pending' AFTER subtotal;

-- Add completed_at column if not exists
ALTER TABLE transaction_items 
ADD COLUMN IF NOT EXISTS completed_at DATETIME NULL AFTER status;

-- Update existing items to pending status
UPDATE transaction_items SET status = 'pending' WHERE status IS NULL;






