<?php
/**
 * Migration: Add status column to transaction_items
 * Date: 2024-01-01
 */

class AddTransactionItemsStatus extends Migration {
    
    public function up() {
        // Add status column if not exists
        if (!$this->columnExists('transaction_items', 'status')) {
            $this->execute("ALTER TABLE transaction_items 
                ADD COLUMN status ENUM('pending', 'preparing', 'ready', 'completed') 
                DEFAULT 'pending' AFTER subtotal");
            
            // Update existing items
            $this->execute("UPDATE transaction_items SET status = 'pending' WHERE status IS NULL");
        }
        
        // Add completed_at column if not exists
        if (!$this->columnExists('transaction_items', 'completed_at')) {
            $this->execute("ALTER TABLE transaction_items 
                ADD COLUMN completed_at DATETIME NULL AFTER status");
        }
    }
    
    public function down() {
        // Remove columns
        if ($this->columnExists('transaction_items', 'completed_at')) {
            $this->execute("ALTER TABLE transaction_items DROP COLUMN completed_at");
        }
        
        if ($this->columnExists('transaction_items', 'status')) {
            $this->execute("ALTER TABLE transaction_items DROP COLUMN status");
        }
    }
}






