<?php
/**
 * Migration: Add waiters and dapur roles to users table
 * Date: 2024-01-01
 */

class AddWaitersDapurRoles extends Migration {
    
    public function up() {
        // Update role ENUM to include waiters and dapur
        $this->execute("ALTER TABLE users 
            MODIFY COLUMN role ENUM('admin', 'manager', 'cashier', 'waiters', 'dapur') 
            DEFAULT 'cashier'");
        
        // Create waiters user if not exists
        $check = $this->db->prepare("SELECT id FROM users WHERE username = 'waiters'");
        $check->execute();
        $result = $check->get_result();
        
        if ($result->num_rows == 0) {
            $password = hash('sha256', 'waiters123' . 'pos_salt_2024');
            $stmt = $this->db->prepare("INSERT INTO users (username, password, name, role) VALUES (?, ?, ?, ?)");
            $name = 'Waiter 1';
            $role = 'waiters';
            $stmt->bind_param("ssss", $username, $password, $name, $role);
            $username = 'waiters';
            $stmt->execute();
        }
        
        // Create dapur user if not exists
        $check = $this->db->prepare("SELECT id FROM users WHERE username = 'dapur'");
        $check->execute();
        $result = $check->get_result();
        
        if ($result->num_rows == 0) {
            $password = hash('sha256', 'dapur123' . 'pos_salt_2024');
            $stmt = $this->db->prepare("INSERT INTO users (username, password, name, role) VALUES (?, ?, ?, ?)");
            $name = 'Staff Dapur';
            $role = 'dapur';
            $stmt->bind_param("ssss", $username, $password, $name, $role);
            $username = 'dapur';
            $stmt->execute();
        }
    }
    
    public function down() {
        // Remove waiters and dapur users
        $this->execute("DELETE FROM users WHERE username IN ('waiters', 'dapur')");
        
        // Revert role ENUM (keep waiters and dapur for backward compatibility, just remove users)
        // Note: We don't revert ENUM because it might break existing data
    }
}






