<?php
/**
 * Migration: Add payment_status and paid_at to transactions table
 * Date: 2024-01-01
 */

class AddPaymentStatus extends Migration {
    
    public function up() {
        // Add payment_status column if not exists
        if (!$this->columnExists('transactions', 'payment_status')) {
            $this->execute("ALTER TABLE transactions 
                ADD COLUMN payment_status ENUM('unpaid', 'paid') 
                DEFAULT 'paid' AFTER status");
            
            // Update existing transactions to be marked as paid
            $this->execute("UPDATE transactions SET payment_status = 'paid' 
                WHERE payment_status IS NULL OR payment_status = ''");
        }
        
        // Add paid_at column if not exists
        if (!$this->columnExists('transactions', 'paid_at')) {
            $this->execute("ALTER TABLE transactions 
                ADD COLUMN paid_at DATETIME NULL AFTER payment_status");
            
            // Update existing paid transactions to have paid_at = created_at
            $this->execute("UPDATE transactions SET paid_at = created_at 
                WHERE payment_status = 'paid' AND paid_at IS NULL");
        }
    }
    
    public function down() {
        // Remove columns
        if ($this->columnExists('transactions', 'paid_at')) {
            $this->execute("ALTER TABLE transactions DROP COLUMN paid_at");
        }
        
        if ($this->columnExists('transactions', 'payment_status')) {
            $this->execute("ALTER TABLE transactions DROP COLUMN payment_status");
        }
    }
}






