<?php
/**
 * Migration: Add transaction_tables for merge tables feature
 * Date: 2024-01-01
 */

class AddTransactionTablesMerge extends Migration {
    
    public function up() {
        // Create transaction_tables junction table if not exists
        if (!$this->tableExists('transaction_tables')) {
            $this->execute("CREATE TABLE transaction_tables (
                id INT AUTO_INCREMENT PRIMARY KEY,
                transaction_id INT NOT NULL,
                table_id INT NOT NULL,
                is_primary BOOLEAN DEFAULT FALSE,
                created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
                FOREIGN KEY (transaction_id) REFERENCES transactions(id) ON DELETE CASCADE,
                FOREIGN KEY (table_id) REFERENCES tables(id) ON DELETE CASCADE,
                UNIQUE KEY unique_transaction_table (transaction_id, table_id)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
        }
        
        // Migrate existing table_id to transaction_tables
        $check = $this->db->query("SELECT COUNT(*) as count FROM transaction_tables");
        $row = $check->fetch_assoc();
        
        if ($row['count'] == 0) {
            // Only migrate if table is empty
            $this->execute("INSERT INTO transaction_tables (transaction_id, table_id, is_primary)
                SELECT id, table_id, TRUE
                FROM transactions
                WHERE table_id IS NOT NULL
                AND NOT EXISTS (
                    SELECT 1 FROM transaction_tables tt 
                    WHERE tt.transaction_id = transactions.id AND tt.table_id = transactions.table_id
                )");
        }
    }
    
    public function down() {
        // Remove transaction_tables table
        if ($this->tableExists('transaction_tables')) {
            $this->execute("DROP TABLE transaction_tables");
        }
    }
}






