<?php
/**
 * Categories Management
 */
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/functions.php';

requireLogin();
$auth = new Auth();
$auth->requirePermission('manager');

$pageTitle = 'Kategori';

$category = new Category();

// Handle actions
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $action = $_POST['action'] ?? '';
    
    if ($action == 'create') {
        $name = $_POST['name'] ?? '';
        $description = $_POST['description'] ?? '';
        if ($category->create($name, $description)) {
            setFlash('success', 'Kategori berhasil ditambahkan!');
        } else {
            setFlash('error', 'Gagal menambahkan kategori!');
        }
        redirect(BASE_URL . 'public/categories.php');
    }
    
    if ($action == 'update') {
        $id = $_POST['id'] ?? 0;
        $name = $_POST['name'] ?? '';
        $description = $_POST['description'] ?? '';
        if ($category->update($id, $name, $description)) {
            setFlash('success', 'Kategori berhasil diupdate!');
        } else {
            setFlash('error', 'Gagal mengupdate kategori!');
        }
        redirect(BASE_URL . 'public/categories.php');
    }
    
    if ($action == 'delete') {
        $id = $_POST['id'] ?? 0;
        if ($category->delete($id)) {
            setFlash('success', 'Kategori berhasil dihapus!');
        } else {
            setFlash('error', 'Gagal menghapus kategori!');
        }
        redirect(BASE_URL . 'public/categories.php');
    }
}

$categories = $category->getAll();
include __DIR__ . '/includes/header.php';
?>

<div class="page-header">
    <h1>Manajemen Kategori</h1>
    <button class="btn btn-primary" onclick="showModal('createModal')">+ Tambah Kategori</button>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Nama</th>
                        <th>Deskripsi</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($categories)): ?>
                        <tr>
                            <td colspan="4" class="text-center">Belum ada kategori</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($categories as $cat): ?>
                            <tr>
                                <td><?php echo $cat['id']; ?></td>
                                <td><strong><?php echo escape($cat['name']); ?></strong></td>
                                <td><?php echo escape($cat['description'] ?? '-'); ?></td>
                                <td>
                                    <button class="btn btn-xs btn-primary" onclick="editCategory(<?php echo htmlspecialchars(json_encode($cat)); ?>)">Edit</button>
                                    <form method="POST" style="display:inline;" onsubmit="return confirm('Yakin hapus kategori ini?');">
                                        <input type="hidden" name="action" value="delete">
                                        <input type="hidden" name="id" value="<?php echo $cat['id']; ?>">
                                        <button type="submit" class="btn btn-xs btn-danger">Hapus</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Create Modal -->
<div id="createModal" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h2>Tambah Kategori</h2>
            <span class="close" onclick="closeModal('createModal')">&times;</span>
        </div>
        <form method="POST">
            <input type="hidden" name="action" value="create">
            <div class="modal-body">
                <div class="form-group">
                    <label>Nama Kategori *</label>
                    <input type="text" name="name" required>
                </div>
                <div class="form-group">
                    <label>Deskripsi</label>
                    <textarea name="description" rows="3"></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="closeModal('createModal')">Batal</button>
                <button type="submit" class="btn btn-primary">Simpan</button>
            </div>
        </form>
    </div>
</div>

<!-- Edit Modal -->
<div id="editModal" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h2>Edit Kategori</h2>
            <span class="close" onclick="closeModal('editModal')">&times;</span>
        </div>
        <form method="POST">
            <input type="hidden" name="action" value="update">
            <input type="hidden" name="id" id="edit_id">
            <div class="modal-body">
                <div class="form-group">
                    <label>Nama Kategori *</label>
                    <input type="text" name="name" id="edit_name" required>
                </div>
                <div class="form-group">
                    <label>Deskripsi</label>
                    <textarea name="description" id="edit_description" rows="3"></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="closeModal('editModal')">Batal</button>
                <button type="submit" class="btn btn-primary">Update</button>
            </div>
        </form>
    </div>
</div>

<script>
function editCategory(cat) {
    document.getElementById('edit_id').value = cat.id;
    document.getElementById('edit_name').value = cat.name;
    document.getElementById('edit_description').value = cat.description || '';
    showModal('editModal');
}
</script>

<?php include __DIR__ . '/includes/footer.php'; ?>






