<?php
if (!isLoggedIn()) {
    redirect(BASE_URL . 'public/login.php');
}
$currentUser = getCurrentUser();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, shrink-to-fit=no">
    <title><?php echo isset($pageTitle) ? $pageTitle . ' - ' : ''; ?><?php echo APP_NAME; ?></title>
    
    <!-- PWA Manifest -->
    <link rel="manifest" href="<?php echo BASE_URL; ?>public/manifest.json">
    <meta name="theme-color" content="#6366F1">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="apple-mobile-web-app-title" content="POS Coffee">
    
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>public/assets/css/style.css">
    
    <!-- Offline Support Scripts -->
    <script src="<?php echo BASE_URL; ?>public/assets/js/offline-db.js"></script>
    <script src="<?php echo BASE_URL; ?>public/assets/js/sync-engine.js"></script>
    <script src="<?php echo BASE_URL; ?>public/assets/js/offline-status.js"></script>
    
    <script>
    // Register Service Worker
    if ('serviceWorker' in navigator) {
        window.addEventListener('load', () => {
            navigator.serviceWorker.register('<?php echo BASE_URL; ?>public/sw.js')
                .then(registration => {
                    console.log('[SW] Service Worker registered:', registration);
                    
                    // Check for updates
                    registration.addEventListener('updatefound', () => {
                        const newWorker = registration.installing;
                        newWorker.addEventListener('statechange', () => {
                            if (newWorker.state === 'installed' && navigator.serviceWorker.controller) {
                                // New service worker available
                                console.log('[SW] New service worker available');
                            }
                        });
                    });
                })
                .catch(error => {
                    console.error('[SW] Service Worker registration failed:', error);
                });
        });
    }
    
    // Initialize offline database when page loads
    window.addEventListener('load', async () => {
        try {
            await offlineDB.init();
            console.log('[App] Offline database initialized');
            
            // Initialize sync engine
            await syncEngine.init();
            console.log('[App] Sync engine initialized');
        } catch (error) {
            console.error('[App] Initialization error:', error);
        }
    });
    </script>
</head>
<body>
    <nav class="navbar">
        <div class="navbar-brand">
            <h2>☕ <?php echo APP_NAME; ?></h2>
        </div>
        <div class="navbar-menu">
            <a href="<?php echo BASE_URL; ?>public/dashboard.php" class="nav-link">Dashboard</a>
            <?php if ($currentUser['role'] != 'dapur'): ?>
                <a href="<?php echo BASE_URL; ?>public/pos.php" class="nav-link">POS</a>
            <?php endif; ?>
            <?php if (in_array($currentUser['role'], ['dapur', 'waiters', 'manager', 'admin'])): ?>
                <a href="<?php echo BASE_URL; ?>public/kitchen.php" class="nav-link">🏪 Dapur</a>
            <?php endif; ?>
            <?php if (in_array($currentUser['role'], ['waiters', 'manager', 'admin'])): ?>
                <a href="<?php echo BASE_URL; ?>public/waiter.php" class="nav-link">🍽️ Waiter</a>
            <?php endif; ?>
            <?php if (hasPermission('manager')): ?>
                <a href="<?php echo BASE_URL; ?>public/products.php" class="nav-link">Produk</a>
                <a href="<?php echo BASE_URL; ?>public/categories.php" class="nav-link">Kategori</a>
                <a href="<?php echo BASE_URL; ?>public/tables.php" class="nav-link">🪑 Meja</a>
            <?php endif; ?>
            <a href="<?php echo BASE_URL; ?>public/transactions.php" class="nav-link">Transaksi</a>
            <?php if (hasPermission('manager')): ?>
                <a href="<?php echo BASE_URL; ?>public/reports.php" class="nav-link">Laporan</a>
            <?php endif; ?>
            <?php if (hasPermission('admin')): ?>
                <a href="<?php echo BASE_URL; ?>public/users.php" class="nav-link">Pengguna</a>
            <?php endif; ?>
            <?php if (in_array($currentUser['role'], ['admin', 'manager'])): ?>
                <a href="<?php echo BASE_URL; ?>public/migrate.php" class="nav-link">🔧 Migrations</a>
            <?php endif; ?>
        </div>
        <div class="navbar-user">
            <span>Selamat datang, <?php echo escape($currentUser['name']); ?></span>
            <a href="<?php echo BASE_URL; ?>public/logout.php" class="btn btn-sm btn-outline">Logout</a>
        </div>
    </nav>
    
    <div class="container">
        <?php 
        $error = getFlash('error');
        $success = getFlash('success');
        if ($error): ?>
            <div class="alert alert-error"><?php echo escape($error); ?></div>
        <?php endif; ?>
        <?php if ($success): ?>
            <div class="alert alert-success"><?php echo escape($success); ?></div>
        <?php endif; ?>

