<?php
/**
 * Login Page
 */
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/functions.php';

// Redirect if already logged in
if (isLoggedIn()) {
    redirect(BASE_URL . 'public/dashboard.php');
}

$error = getFlash('error');
$success = getFlash('success');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    if (empty($username) || empty($password)) {
        setFlash('error', 'Username dan password harus diisi!');
        redirect(BASE_URL . 'public/login.php');
    }
    
    $auth = new Auth();
    if ($auth->login($username, $password)) {
        redirect(BASE_URL . 'public/dashboard.php');
    } else {
        setFlash('error', 'Username atau password salah!');
        redirect(BASE_URL . 'public/login.php');
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>public/assets/css/style.css">
</head>
<body class="login-page">
    <div class="login-container">
        <div class="login-box">
            <div class="login-header">
                <h1>☕ <?php echo APP_NAME; ?></h1>
                <p>Masuk ke akun Anda</p>
            </div>
            
            <?php if ($error): ?>
                <div class="alert alert-error"><?php echo escape($error); ?></div>
            <?php endif; ?>
            
            <?php if ($success): ?>
                <div class="alert alert-success"><?php echo escape($success); ?></div>
            <?php endif; ?>
            
            <form method="POST" action="" class="login-form">
                <div class="form-group">
                    <label for="username">Username</label>
                    <input type="text" id="username" name="username" required autofocus>
                </div>
                
                <div class="form-group">
                    <label for="password">Password</label>
                    <input type="password" id="password" name="password" required>
                </div>
                
                <button type="submit" class="btn btn-primary btn-block">Masuk</button>
            </form>
            
            <div class="login-footer">
                <p>Default: admin / admin123</p>
            </div>
        </div>
    </div>
</body>
</html>






