<?php
/**
 * Products Management
 */
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/functions.php';

requireLogin();
$auth = new Auth();
$auth->requirePermission('manager');

$pageTitle = 'Produk';

$product = new Product();
$category = new Category();

// Handle actions
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $action = $_POST['action'] ?? '';
    
    if ($action == 'create') {
        $data = [
            'code' => $_POST['code'] ?? '',
            'name' => $_POST['name'] ?? '',
            'category_id' => $_POST['category_id'] ?? 0,
            'price' => $_POST['price'] ?? 0,
            'stock' => $_POST['stock'] ?? 0,
            'description' => $_POST['description'] ?? ''
        ];
        if ($product->create($data)) {
            setFlash('success', 'Produk berhasil ditambahkan!');
        } else {
            setFlash('error', 'Gagal menambahkan produk!');
        }
        redirect(BASE_URL . 'public/products.php');
    }
    
    if ($action == 'update') {
        $id = $_POST['id'] ?? 0;
        $data = [
            'code' => $_POST['code'] ?? '',
            'name' => $_POST['name'] ?? '',
            'category_id' => $_POST['category_id'] ?? 0,
            'price' => $_POST['price'] ?? 0,
            'stock' => $_POST['stock'] ?? 0,
            'description' => $_POST['description'] ?? ''
        ];
        if ($product->update($id, $data)) {
            setFlash('success', 'Produk berhasil diupdate!');
        } else {
            setFlash('error', 'Gagal mengupdate produk!');
        }
        redirect(BASE_URL . 'public/products.php');
    }
    
    if ($action == 'delete') {
        $id = $_POST['id'] ?? 0;
        if ($product->delete($id)) {
            setFlash('success', 'Produk berhasil dihapus!');
        } else {
            setFlash('error', 'Gagal menghapus produk!');
        }
        redirect(BASE_URL . 'public/products.php');
    }
}

$products = $product->getAll();
$categories = $category->getAll();
include __DIR__ . '/includes/header.php';
?>

<div class="page-header">
    <h1>Manajemen Produk</h1>
    <button class="btn btn-primary" onclick="showModal('createModal')">+ Tambah Produk</button>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th>Kode</th>
                        <th>Nama</th>
                        <th>Kategori</th>
                        <th>Harga</th>
                        <th>Stok</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($products)): ?>
                        <tr>
                            <td colspan="6" class="text-center">Belum ada produk</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($products as $prod): ?>
                            <tr>
                                <td><strong><?php echo escape($prod['code']); ?></strong></td>
                                <td><?php echo escape($prod['name']); ?></td>
                                <td><?php echo escape($prod['category_name'] ?? '-'); ?></td>
                                <td><?php echo formatCurrency($prod['price']); ?></td>
                                <td>
                                    <span class="badge <?php echo $prod['stock'] > 10 ? 'badge-success' : 'badge-warning'; ?>">
                                        <?php echo $prod['stock']; ?>
                                    </span>
                                </td>
                                <td>
                                    <button class="btn btn-xs btn-primary" onclick="editProduct(<?php echo htmlspecialchars(json_encode($prod)); ?>)">Edit</button>
                                    <form method="POST" style="display:inline;" onsubmit="return confirm('Yakin hapus produk ini?');">
                                        <input type="hidden" name="action" value="delete">
                                        <input type="hidden" name="id" value="<?php echo $prod['id']; ?>">
                                        <button type="submit" class="btn btn-xs btn-danger">Hapus</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Create Modal -->
<div id="createModal" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h2>Tambah Produk</h2>
            <span class="close" onclick="closeModal('createModal')">&times;</span>
        </div>
        <form method="POST">
            <input type="hidden" name="action" value="create">
            <div class="modal-body">
                <div class="form-group">
                    <label>Kode Produk *</label>
                    <input type="text" name="code" required>
                </div>
                <div class="form-group">
                    <label>Nama Produk *</label>
                    <input type="text" name="name" required>
                </div>
                <div class="form-group">
                    <label>Kategori *</label>
                    <select name="category_id" required>
                        <option value="">Pilih Kategori</option>
                        <?php foreach ($categories as $cat): ?>
                            <option value="<?php echo $cat['id']; ?>"><?php echo escape($cat['name']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>Harga *</label>
                        <input type="number" name="price" min="0" step="100" required>
                    </div>
                    <div class="form-group">
                        <label>Stok *</label>
                        <input type="number" name="stock" min="0" required>
                    </div>
                </div>
                <div class="form-group">
                    <label>Deskripsi</label>
                    <textarea name="description" rows="3"></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="closeModal('createModal')">Batal</button>
                <button type="submit" class="btn btn-primary">Simpan</button>
            </div>
        </form>
    </div>
</div>

<!-- Edit Modal -->
<div id="editModal" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h2>Edit Produk</h2>
            <span class="close" onclick="closeModal('editModal')">&times;</span>
        </div>
        <form method="POST">
            <input type="hidden" name="action" value="update">
            <input type="hidden" name="id" id="edit_id">
            <div class="modal-body">
                <div class="form-group">
                    <label>Kode Produk *</label>
                    <input type="text" name="code" id="edit_code" required>
                </div>
                <div class="form-group">
                    <label>Nama Produk *</label>
                    <input type="text" name="name" id="edit_name" required>
                </div>
                <div class="form-group">
                    <label>Kategori *</label>
                    <select name="category_id" id="edit_category_id" required>
                        <option value="">Pilih Kategori</option>
                        <?php foreach ($categories as $cat): ?>
                            <option value="<?php echo $cat['id']; ?>"><?php echo escape($cat['name']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>Harga *</label>
                        <input type="number" name="price" id="edit_price" min="0" step="100" required>
                    </div>
                    <div class="form-group">
                        <label>Stok *</label>
                        <input type="number" name="stock" id="edit_stock" min="0" required>
                    </div>
                </div>
                <div class="form-group">
                    <label>Deskripsi</label>
                    <textarea name="description" id="edit_description" rows="3"></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="closeModal('editModal')">Batal</button>
                <button type="submit" class="btn btn-primary">Update</button>
            </div>
        </form>
    </div>
</div>

<script>
function editProduct(prod) {
    document.getElementById('edit_id').value = prod.id;
    document.getElementById('edit_code').value = prod.code;
    document.getElementById('edit_name').value = prod.name;
    document.getElementById('edit_category_id').value = prod.category_id;
    document.getElementById('edit_price').value = prod.price;
    document.getElementById('edit_stock').value = prod.stock;
    document.getElementById('edit_description').value = prod.description || '';
    showModal('editModal');
}
</script>

<?php include __DIR__ . '/includes/footer.php'; ?>






