<?php
/**
 * Reports
 */
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/functions.php';

requireLogin();
$auth = new Auth();
$auth->requirePermission('manager');

$pageTitle = 'Laporan';

$transaction = new Transaction();

$date_from = $_GET['date_from'] ?? date('Y-m-01'); // First day of month
$date_to = $_GET['date_to'] ?? date('Y-m-t'); // Last day of month

$summary = $transaction->getSalesSummary($date_from, $date_to);
$transactions = $transaction->getAll($date_from, $date_to);

include __DIR__ . '/includes/header.php';
?>

<div class="page-header">
    <h1>Laporan Penjualan</h1>
</div>

<div class="card">
    <div class="card-header">
        <h2>Filter Periode</h2>
    </div>
    <div class="card-body">
        <form method="GET" class="form-inline">
            <div class="form-group">
                <label>Dari Tanggal:</label>
                <input type="date" name="date_from" value="<?php echo escape($date_from); ?>" class="form-control">
            </div>
            <div class="form-group">
                <label>Sampai Tanggal:</label>
                <input type="date" name="date_to" value="<?php echo escape($date_to); ?>" class="form-control">
            </div>
            <button type="submit" class="btn btn-primary">Filter</button>
            <a href="<?php echo BASE_URL; ?>public/reports.php" class="btn btn-secondary">Bulan Ini</a>
        </form>
    </div>
</div>

<div class="stats-grid">
    <div class="stat-card stat-primary">
        <div class="stat-icon">💰</div>
        <div class="stat-content">
            <h3>Total Pendapatan</h3>
            <p class="stat-value"><?php echo formatCurrency($summary['total_revenue'] ?? 0); ?></p>
        </div>
    </div>
    
    <div class="stat-card stat-success">
        <div class="stat-icon">📊</div>
        <div class="stat-content">
            <h3>Total Transaksi</h3>
            <p class="stat-value"><?php echo number_format($summary['total_transactions'] ?? 0); ?></p>
        </div>
    </div>
    
    <div class="stat-card stat-info">
        <div class="stat-icon">💵</div>
        <div class="stat-content">
            <h3>Tunai</h3>
            <p class="stat-value"><?php echo formatCurrency($summary['cash_revenue'] ?? 0); ?></p>
        </div>
    </div>
    
    <div class="stat-card stat-warning">
        <div class="stat-icon">💳</div>
        <div class="stat-content">
            <h3>Kartu</h3>
            <p class="stat-value"><?php echo formatCurrency($summary['card_revenue'] ?? 0); ?></p>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h2>Detail Transaksi</h2>
        <button onclick="window.print()" class="btn btn-sm btn-primary">Cetak Laporan</button>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th>Invoice</th>
                        <th>Kasir</th>
                        <th>Total</th>
                        <th>Metode</th>
                        <th>Tanggal</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($transactions)): ?>
                        <tr>
                            <td colspan="5" class="text-center">Tidak ada transaksi pada periode ini</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($transactions as $t): ?>
                            <tr>
                                <td><?php echo escape($t['invoice_number']); ?></td>
                                <td><?php echo escape($t['cashier_name']); ?></td>
                                <td><?php echo formatCurrency($t['total']); ?></td>
                                <td><span class="badge badge-info"><?php echo escape($t['payment_method']); ?></span></td>
                                <td><?php echo formatDate($t['created_at']); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>






