<?php
/**
 * Transaction Detail / Receipt
 */
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/functions.php';

requireLogin();

$currentUser = getCurrentUser();
$isWaiter = ($currentUser['role'] == 'waiters');

$id = $_GET['id'] ?? 0;
$print = isset($_GET['print']);

$transaction = new Transaction();
$trans = $transaction->getById($id);
$items = $transaction->getItems($id);

if (!$trans) {
    setFlash('error', 'Transaksi tidak ditemukan!');
    redirect(BASE_URL . 'public/transactions.php');
}

$pageTitle = 'Detail Transaksi';
include __DIR__ . '/includes/header.php';
?>

<?php if ($isWaiter): ?>
<style>
/* Hide navbar for waiters */
body .navbar {
    display: none !important;
}

body .container {
    max-width: 100% !important;
    margin: 0 !important;
    padding: 1rem !important;
}

/* Elegant background for waiter */
body {
    background: linear-gradient(135deg, #F0F4FF 0%, #E0E7FF 30%, #F8FAFF 60%, #EDE9FE 100%) !important;
    background-attachment: fixed;
    position: relative;
}

body::before {
    content: '';
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: 
        radial-gradient(circle at 20% 50%, rgba(99, 102, 241, 0.1) 0%, transparent 50%),
        radial-gradient(circle at 80% 80%, rgba(139, 92, 246, 0.1) 0%, transparent 50%),
        radial-gradient(circle at 40% 20%, rgba(236, 72, 153, 0.05) 0%, transparent 50%);
    pointer-events: none;
    z-index: 0;
}

body > * {
    position: relative;
    z-index: 1;
}
</style>
<?php endif; ?>

<?php if ($isWaiter): ?>
<!-- Waiter Header - Compact -->
<div class="waiter-pos-header-compact">
    <div class="waiter-pos-title-compact">
        <h1>📋 Detail Transaksi</h1>
        <span class="waiter-name"><?php echo escape($currentUser['name']); ?></span>
    </div>
    <div class="waiter-pos-controls-compact">
        <a href="<?php echo BASE_URL; ?>public/dashboard.php" class="btn-compact btn-dashboard" title="Kembali ke Dashboard">
            <span class="btn-icon">🏠</span>
            <span class="btn-label">Dashboard</span>
        </a>
        <a href="<?php echo BASE_URL; ?>public/pos.php" class="btn-compact btn-pos" title="POS">
            <span class="btn-icon">💰</span>
            <span class="btn-label">POS</span>
        </a>
        <a href="<?php echo BASE_URL; ?>public/waiter.php" class="btn-compact btn-waiter" title="Waiter">
            <span class="btn-icon">🍽️</span>
            <span class="btn-label">Waiter</span>
        </a>
        <?php if (in_array($currentUser['role'], ['dapur', 'waiters', 'manager', 'admin'])): ?>
        <a href="<?php echo BASE_URL; ?>public/kitchen.php" class="btn-compact btn-kitchen" title="Dapur">
            <span class="btn-icon">🏪</span>
            <span class="btn-label">Dapur</span>
        </a>
        <?php endif; ?>
        <a href="<?php echo BASE_URL; ?>public/transactions.php" class="btn-compact btn-transactions" title="Transaksi">
            <span class="btn-icon">📋</span>
            <span class="btn-label">Transaksi</span>
        </a>
        <button class="btn-compact btn-refresh" onclick="location.reload()" title="Refresh">
            <span class="btn-icon">🔄</span>
            <span class="btn-label">Refresh</span>
        </button>
        <button class="btn-compact btn-fullscreen" id="fullscreenBtn" onclick="toggleFullscreen()" title="Fullscreen">
            <span class="btn-icon" id="fullscreenIcon">⛶</span>
            <span class="btn-label">Fullscreen</span>
        </button>
    </div>
</div>
<?php else: ?>
<div class="page-header">
    <h1>📋 Detail Transaksi</h1>
    <div class="quick-nav">
        <a href="<?php echo BASE_URL; ?>public/dashboard.php" class="quick-nav-btn" title="Dashboard">
            <span class="quick-nav-icon">🏠</span>
            <span class="quick-nav-label">Dashboard</span>
        </a>
        <a href="<?php echo BASE_URL; ?>public/pos.php" class="quick-nav-btn" title="POS">
            <span class="quick-nav-icon">💰</span>
            <span class="quick-nav-label">POS</span>
        </a>
        <?php if (in_array($currentUser['role'], ['dapur', 'waiters', 'manager', 'admin'])): ?>
        <a href="<?php echo BASE_URL; ?>public/kitchen.php" class="quick-nav-btn" title="Dapur">
            <span class="quick-nav-icon">🏪</span>
            <span class="quick-nav-label">Dapur</span>
        </a>
        <?php endif; ?>
        <?php if (in_array($currentUser['role'], ['waiters', 'manager', 'admin'])): ?>
        <a href="<?php echo BASE_URL; ?>public/waiter.php" class="quick-nav-btn" title="Waiter">
            <span class="quick-nav-icon">🍽️</span>
            <span class="quick-nav-label">Waiter</span>
        </a>
        <?php endif; ?>
        <a href="<?php echo BASE_URL; ?>public/transactions.php" class="quick-nav-btn" title="Transaksi">
            <span class="quick-nav-icon">📋</span>
            <span class="quick-nav-label">Transaksi</span>
        </a>
        <button class="quick-nav-btn" onclick="location.reload()" title="Refresh">
            <span class="quick-nav-icon">🔄</span>
            <span class="quick-nav-label">Refresh</span>
        </button>
        <button class="quick-nav-btn" id="fullscreenBtn" onclick="toggleFullscreen()" title="Fullscreen">
            <span class="quick-nav-icon" id="fullscreenIcon">⛶</span>
            <span class="quick-nav-label">Fullscreen</span>
        </button>
    </div>
</div>
<?php endif; ?>

<div class="transaction-detail-container <?php echo $isWaiter ? 'waiter-detail-container' : ''; ?> <?php echo $print ? 'print-mode' : ''; ?>">
    <div class="receipt-paper <?php echo $print ? 'receipt-print' : ''; ?>">
        <div class="receipt-content">
            <!-- Receipt Header -->
            <div class="receipt-header-struk">
                <div class="receipt-title"><?php echo APP_NAME; ?></div>
                <div class="receipt-address">Jl. Contoh No. 123, Jakarta</div>
                <div class="receipt-phone">Telp: (021) 12345678</div>
                <div class="receipt-line">================================</div>
            </div>
            
            <!-- Receipt Info -->
            <div class="receipt-info-struk">
                <div class="receipt-line-item">
                    <span class="receipt-label">Invoice:</span>
                    <span class="receipt-value"><?php echo escape($trans['invoice_number']); ?></span>
                </div>
                <div class="receipt-line-item">
                    <span class="receipt-label">Tanggal:</span>
                    <span class="receipt-value"><?php echo formatDate($trans['created_at'], 'd/m/Y H:i'); ?></span>
                </div>
                <div class="receipt-line-item">
                    <span class="receipt-label">Kasir:</span>
                    <span class="receipt-value"><?php echo escape($trans['cashier_name']); ?></span>
                </div>
                <?php if (!empty($trans['table_name']) || !empty($trans['merged_tables'])): ?>
                    <div class="receipt-line-item">
                        <span class="receipt-label">Meja:</span>
                        <span class="receipt-value">
                            <?php if (!empty($trans['is_merged']) && !empty($trans['merged_tables'])): ?>
                                <?php 
                                $merged_names = array_map(function($t) { 
                                    return $t['name']; 
                                }, $trans['merged_tables']); 
                                echo escape(implode(', ', $merged_names)); 
                                ?>
                            <?php else: ?>
                                <?php echo escape($trans['table_name']); ?>
                            <?php endif; ?>
                        </span>
                    </div>
                <?php else: ?>
                    <div class="receipt-line-item">
                        <span class="receipt-label">Tipe:</span>
                        <span class="receipt-value">Take Away</span>
                    </div>
                <?php endif; ?>
                <div class="receipt-line">--------------------------------</div>
            </div>
            
            <!-- Receipt Items -->
            <div class="receipt-items-struk">
                <?php foreach ($items as $item): 
                    $status = $item['status'] ?? 'pending';
                    $status_labels = [
                        'pending' => 'Menunggu',
                        'preparing' => 'Memasak',
                        'ready' => 'Siap',
                        'completed' => 'Selesai'
                    ];
                    $status_label = $status_labels[$status] ?? 'Unknown';
                ?>
                    <div class="receipt-item-row">
                        <div class="receipt-item-left">
                            <div class="receipt-item-name"><?php echo escape($item['product_name']); ?></div>
                            <div class="receipt-item-detail">
                                <span class="receipt-item-qty"><?php echo $item['quantity']; ?>x</span>
                                <span class="receipt-item-price"><?php echo formatCurrency($item['price']); ?></span>
                            </div>
                            <?php if (!$print): ?>
                                <div class="receipt-item-status">[<?php echo $status_label; ?>]</div>
                            <?php endif; ?>
                        </div>
                        <div class="receipt-item-right">
                            <span class="receipt-item-subtotal"><?php echo formatCurrency($item['subtotal']); ?></span>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            
            <div class="receipt-line">================================</div>
            
            <!-- Receipt Total -->
            <div class="receipt-total-struk">
                <div class="receipt-total-row">
                    <span class="receipt-total-label">TOTAL:</span>
                    <span class="receipt-total-amount"><?php echo formatCurrency($trans['total']); ?></span>
                </div>
                <?php if (($trans['payment_status'] ?? 'paid') === 'paid'): ?>
                    <?php if ($trans['payment_method'] == 'cash'): ?>
                        <div class="receipt-payment-row">
                            <span class="receipt-payment-label">Tunai:</span>
                            <span class="receipt-payment-value"><?php echo formatCurrency($trans['cash_received']); ?></span>
                        </div>
                        <div class="receipt-payment-row">
                            <span class="receipt-payment-label">Kembalian:</span>
                            <span class="receipt-payment-value"><?php echo formatCurrency($trans['change_amount']); ?></span>
                        </div>
                    <?php else: ?>
                        <div class="receipt-payment-row">
                            <span class="receipt-payment-label">Metode:</span>
                            <span class="receipt-payment-value"><?php echo strtoupper(escape($trans['payment_method'])); ?></span>
                        </div>
                    <?php endif; ?>
                    <div class="receipt-payment-status">✓ LUNAS</div>
                <?php else: ?>
                    <div class="receipt-payment-status unpaid">⚠ BELUM DIBAYAR</div>
                <?php endif; ?>
            </div>
            
            <div class="receipt-line">================================</div>
            
            <!-- Receipt Footer -->
            <div class="receipt-footer-struk">
                <div class="receipt-thanks">Terima Kasih</div>
                <div class="receipt-note">Barang yang sudah dibeli tidak dapat ditukar/dikembalikan</div>
            </div>
        </div>
    </div>
    
    <?php if (!$print): ?>
        <div class="receipt-actions-modern">
            <a href="<?php echo BASE_URL; ?>public/transactions.php" class="btn-modern btn-secondary-modern">
                <span class="btn-icon-modern">←</span>
                <span>Kembali</span>
            </a>
            <?php if (($trans['payment_status'] ?? 'paid') === 'unpaid'): ?>
                <a href="<?php echo BASE_URL; ?>public/payment.php?id=<?php echo $id; ?>" class="btn-modern btn-warning-modern">
                    <span class="btn-icon-modern">💳</span>
                    <span>Selesaikan Pembayaran</span>
                </a>
            <?php endif; ?>
            <button onclick="window.print()" class="btn-modern btn-primary-modern">
                <span class="btn-icon-modern">🖨️</span>
                <span>Cetak Struk</span>
            </button>
        </div>
    <?php endif; ?>
</div>

<?php if ($print): ?>
<script>
// Optimize print preview - call print as soon as DOM is ready
(function() {
    // Try multiple methods to trigger print faster
    function triggerPrint() {
        // Use requestAnimationFrame to ensure rendering is complete
        requestAnimationFrame(function() {
            requestAnimationFrame(function() {
                window.print();
            });
        });
    }
    
    // Try to print as soon as possible
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', triggerPrint);
    } else if (document.readyState === 'interactive' || document.readyState === 'complete') {
        // DOM is already ready, trigger print immediately
        triggerPrint();
    } else {
        // Fallback to window.onload
        window.addEventListener('load', triggerPrint);
    }
})();
</script>
<?php endif; ?>

<script>
// Fullscreen functionality
function enterFullscreen() {
    const elem = document.documentElement;
    
    if (!document.fullscreenElement && !document.webkitFullscreenElement && 
        !document.mozFullScreenElement && !document.msFullscreenElement) {
        const promise = elem.requestFullscreen ? elem.requestFullscreen() :
                       elem.webkitRequestFullscreen ? elem.webkitRequestFullscreen() :
                       elem.mozRequestFullScreen ? elem.mozRequestFullScreen() :
                       elem.msRequestFullscreen ? elem.msRequestFullscreen() : null;
        
        if (promise) {
            promise.then(() => {
                updateFullscreenButton();
            }).catch(err => {
                console.log('Fullscreen request failed:', err);
            });
        }
    }
}

function exitFullscreen() {
    if (document.exitFullscreen) {
        document.exitFullscreen();
    } else if (document.webkitExitFullscreen) {
        document.webkitExitFullscreen();
    } else if (document.mozCancelFullScreen) {
        document.mozCancelFullScreen();
    } else if (document.msExitFullscreen) {
        document.msExitFullscreen();
    }
}

function toggleFullscreen() {
    const fullscreenIcon = document.getElementById('fullscreenIcon');
    
    if (!document.fullscreenElement && !document.webkitFullscreenElement && 
        !document.mozFullScreenElement && !document.msFullscreenElement) {
        enterFullscreen();
        if (fullscreenIcon) fullscreenIcon.textContent = '⛶';
        document.body.classList.add('detail-fullscreen-active');
    } else {
        exitFullscreen();
        if (fullscreenIcon) fullscreenIcon.textContent = '⛶';
        document.body.classList.remove('detail-fullscreen-active');
    }
}

document.addEventListener('fullscreenchange', updateFullscreenButton);
document.addEventListener('webkitfullscreenchange', updateFullscreenButton);
document.addEventListener('mozfullscreenchange', updateFullscreenButton);
document.addEventListener('MSFullscreenChange', updateFullscreenButton);

function updateFullscreenButton() {
    const isFullscreen = !!(document.fullscreenElement || document.webkitFullscreenElement || 
                            document.mozFullScreenElement || document.msFullscreenElement);
    const fullscreenIcon = document.getElementById('fullscreenIcon');
    
    if (isFullscreen) {
        if (fullscreenIcon) fullscreenIcon.textContent = '⛶';
        document.body.classList.add('detail-fullscreen-active');
    } else {
        if (fullscreenIcon) fullscreenIcon.textContent = '⛶';
        document.body.classList.remove('detail-fullscreen-active');
    }
}

document.addEventListener('keydown', function(e) {
    if (e.key === 'F11') {
        e.preventDefault();
        toggleFullscreen();
    }
});
</script>

<style>
/* Transaction Detail Modern Styling */
.transaction-detail-container {
    max-width: 900px;
    margin: 0 auto;
    display: flex;
    flex-direction: column;
    gap: 1.5rem;
    visibility: visible !important;
    display: block !important;
}

.waiter-detail-container {
    max-width: 100%;
    gap: 1rem;
}

/* Page Header with Quick Nav */
.page-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 1rem;
    flex-wrap: wrap;
    gap: 1rem;
}

.page-header h1 {
    margin: 0;
    flex: 1;
}

.quick-nav {
    display: flex;
    gap: 0.5rem;
    flex-wrap: wrap;
}

.quick-nav-btn {
    display: inline-flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    gap: 0.25rem;
    padding: 0.5rem 0.75rem;
    background: linear-gradient(135deg, #6366F1, #4F46E5);
    color: white;
    border: none;
    border-radius: 8px;
    text-decoration: none;
    transition: all 0.2s;
    min-width: 60px;
    min-height: 60px;
    box-shadow: 0 2px 6px rgba(99, 102, 241, 0.3);
    cursor: pointer;
    font-family: inherit;
}

.quick-nav-btn:hover {
    background: linear-gradient(135deg, #4F46E5, #7C3AED);
    box-shadow: 0 4px 12px rgba(99, 102, 241, 0.4);
    transform: translateY(-2px);
    text-decoration: none;
    color: white;
}

.quick-nav-icon {
    font-size: 1.25rem;
    line-height: 1;
}

.quick-nav-label {
    font-size: 0.625rem;
    font-weight: 600;
    line-height: 1;
    text-align: center;
    white-space: nowrap;
}

/* Receipt Paper - Struk Pembayaran */
.receipt-paper {
    max-width: 80mm;
    width: 80mm;
    margin: 0 auto;
    background: white;
    padding: 10mm 5mm;
    font-family: 'Courier New', 'Monaco', 'Consolas', monospace;
    font-size: 12px;
    line-height: 1.5;
    color: #000000 !important;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    border: 1px dashed #ddd;
    box-sizing: border-box;
    display: block !important;
    visibility: visible !important;
    opacity: 1 !important;
}

.receipt-print {
    max-width: 80mm;
    width: 80mm;
    margin: 0 auto;
    padding: 3mm 2mm;
    box-shadow: none;
    border: none;
    box-sizing: border-box;
}

.receipt-content {
    width: 100%;
    max-width: 100%;
    box-sizing: border-box;
    word-wrap: break-word;
    overflow-wrap: break-word;
    display: block !important;
    visibility: visible !important;
    color: #000000 !important;
}

/* Receipt Header */
.receipt-header-struk {
    text-align: center;
    margin-bottom: 8px;
    padding-bottom: 8px;
    width: 100%;
    box-sizing: border-box;
    display: block !important;
    visibility: visible !important;
    color: #000000 !important;
}

.receipt-title {
    font-size: 16px;
    font-weight: bold;
    margin-bottom: 6px;
    text-transform: uppercase;
    letter-spacing: 1px;
    word-wrap: break-word;
    color: #000000 !important;
    display: block !important;
    line-height: 1.3;
}

.receipt-address,
.receipt-phone {
    font-size: 10px;
    margin: 2px 0;
    color: #333333 !important;
    word-wrap: break-word;
    display: block !important;
}

.receipt-line {
    text-align: center;
    margin: 8px 0;
    color: #000000 !important;
    font-size: 11px;
    letter-spacing: 0;
    width: 100%;
    overflow: hidden;
    display: block !important;
    line-height: 1;
    font-family: 'Courier New', monospace;
}

/* Receipt Info */
.receipt-info-struk {
    margin-bottom: 8px;
    padding-bottom: 8px;
    width: 100%;
    box-sizing: border-box;
    display: block !important;
    visibility: visible !important;
    color: #000000 !important;
}

.receipt-line-item {
    display: flex !important;
    justify-content: space-between;
    margin: 3px 0;
    font-size: 11px;
    width: 100%;
    box-sizing: border-box;
    color: #000000 !important;
    visibility: visible !important;
    align-items: baseline;
    line-height: 1.4;
}

.receipt-label {
    font-weight: normal;
    text-align: left;
    flex: 0 0 auto;
    margin-right: 4px;
    color: #000000 !important;
    display: inline-block !important;
}

.receipt-value {
    font-weight: normal;
    text-align: right;
    flex: 1;
    word-wrap: break-word;
    overflow-wrap: break-word;
    color: #000000 !important;
    display: inline-block !important;
}

/* Receipt Items */
.receipt-items-struk {
    margin-bottom: 8px;
    padding-bottom: 8px;
    width: 100%;
    box-sizing: border-box;
    display: block !important;
    visibility: visible !important;
    color: #000000 !important;
}

.receipt-item-row {
    margin: 6px 0;
    padding: 4px 0;
    border-bottom: 1px dotted #ccc;
    width: 100%;
    box-sizing: border-box;
    display: flex !important;
    justify-content: space-between;
    align-items: flex-start;
    visibility: visible !important;
    color: #000000 !important;
}

.receipt-item-left {
    flex: 1;
    display: flex;
    flex-direction: column;
    gap: 2px;
}

.receipt-item-right {
    flex: 0 0 auto;
    text-align: right;
    padding-left: 8px;
}

.receipt-item-name {
    font-size: 11px;
    font-weight: normal;
    text-transform: uppercase;
    word-wrap: break-word;
    overflow-wrap: break-word;
    color: #000000 !important;
    display: block !important;
    line-height: 1.3;
}

.receipt-item-detail {
    display: flex !important;
    align-items: center;
    gap: 4px;
    font-size: 10px;
    margin-top: 2px;
    color: #000000 !important;
    visibility: visible !important;
}

.receipt-item-qty {
    color: #000000 !important;
    display: inline-block !important;
}

.receipt-item-price {
    color: #000000 !important;
    display: inline-block !important;
}

.receipt-item-subtotal {
    text-align: right;
    font-weight: normal;
    font-size: 11px;
    color: #000000 !important;
    display: block !important;
    white-space: nowrap;
}

.receipt-item-status {
    font-size: 9px;
    color: #999999 !important;
    margin-top: 2px;
    font-style: normal;
    display: block !important;
    visibility: visible !important;
    font-weight: normal;
}

/* Receipt Total */
.receipt-total-struk {
    margin-bottom: 8px;
    padding-bottom: 8px;
    width: 100%;
    box-sizing: border-box;
    display: block !important;
    visibility: visible !important;
    color: #000000 !important;
}

.receipt-total-row {
    display: flex !important;
    justify-content: space-between;
    margin: 8px 0 4px 0;
    font-size: 12px;
    font-weight: bold;
    padding-top: 6px;
    border-top: 1px solid #000;
    width: 100%;
    box-sizing: border-box;
    color: #000000 !important;
    visibility: visible !important;
    align-items: center;
}

.receipt-total-label {
    text-transform: uppercase;
    flex: 0 0 auto;
    color: #000000 !important;
    display: inline-block !important;
}

.receipt-total-amount {
    font-weight: bold;
    font-size: 13px;
    flex: 0 0 auto;
    text-align: right;
    color: #000000 !important;
    display: inline-block !important;
}

.receipt-payment-row {
    display: flex !important;
    justify-content: space-between;
    margin: 3px 0;
    font-size: 11px;
    width: 100%;
    box-sizing: border-box;
    color: #000000 !important;
    visibility: visible !important;
}

.receipt-payment-label {
    text-align: left;
    flex: 0 0 auto;
    color: #000000 !important;
    display: inline-block !important;
}

.receipt-payment-value {
    text-align: right;
    font-weight: normal;
    flex: 0 0 auto;
    word-wrap: break-word;
    color: #000000 !important;
    display: inline-block !important;
}

.receipt-payment-status {
    text-align: center;
    margin: 8px 0;
    padding: 6px 0;
    font-size: 11px;
    font-weight: bold;
    text-transform: uppercase;
    border-top: 1px dashed #000;
    border-bottom: 1px dashed #000;
    width: 100%;
    box-sizing: border-box;
    color: #000000 !important;
    display: block !important;
    visibility: visible !important;
    line-height: 1.4;
}

.receipt-payment-status.unpaid {
    color: #d00 !important;
    font-size: 12px;
}

/* Receipt Footer */
.receipt-footer-struk {
    text-align: center;
    margin-top: 8px;
    padding-top: 8px;
    width: 100%;
    box-sizing: border-box;
    display: block !important;
    visibility: visible !important;
    color: #000000 !important;
}

.receipt-thanks {
    font-size: 12px;
    font-weight: bold;
    margin-bottom: 6px;
    text-transform: uppercase;
    color: #000000 !important;
    display: block !important;
    letter-spacing: 0.5px;
}

.receipt-note {
    font-size: 9px;
    color: #666666 !important;
    margin-top: 4px;
    line-height: 1.4;
    word-wrap: break-word;
    overflow-wrap: break-word;
    display: block !important;
    font-weight: normal;
}

/* Badges */
.badge-modern {
    display: inline-flex;
    align-items: center;
    gap: 0.375rem;
    padding: 0.5rem 0.75rem;
    border-radius: 6px;
    font-size: 0.8125rem;
    font-weight: 600;
    white-space: nowrap;
}

.badge-success-modern {
    background: linear-gradient(135deg, #D1FAE5, #A7F3D0);
    color: #059669;
    border: 1px solid #6EE7B7;
}

.badge-warning-modern {
    background: linear-gradient(135deg, #FEF3C7, #FDE68A);
    color: #D97706;
    border: 1px solid #FCD34D;
}

.badge-info-modern {
    background: linear-gradient(135deg, #DBEAFE, #BFDBFE);
    color: #2563EB;
    border: 1px solid #93C5FD;
}

.badge-payment-compact {
    background: #E0E7FF;
    color: #4F46E5;
    border: 1px solid #C7D2FE;
    padding: 0.375rem 0.625rem;
    font-size: 0.75rem;
}

.badge-icon {
    font-size: 0.875rem;
    line-height: 1;
}

/* Receipt Footer */
.receipt-footer-modern {
    text-align: center;
    padding: 1.5rem;
    background: #F8FAFF;
    border-radius: 12px;
    margin: 1rem;
}

.footer-thanks {
    font-size: 1.125rem;
    color: #6366F1;
    margin-bottom: 0.5rem;
}

.footer-note {
    font-size: 0.8125rem;
    color: #6B7280;
    margin: 0;
}

/* Receipt Actions */
.receipt-actions-modern {
    display: flex;
    gap: 0.75rem;
    flex-wrap: wrap;
    justify-content: center;
    margin-top: 2rem;
    padding-top: 1.5rem;
}

.btn-modern {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.25rem;
    border: none;
    border-radius: 8px;
    font-weight: 600;
    font-size: 0.9375rem;
    cursor: pointer;
    transition: all 0.2s;
    text-decoration: none;
    min-height: 44px;
}

.btn-primary-modern {
    background: linear-gradient(135deg, #6366F1, #4F46E5);
    color: white;
    box-shadow: 0 4px 12px rgba(99, 102, 241, 0.3);
}

.btn-primary-modern:hover {
    background: linear-gradient(135deg, #4F46E5, #7C3AED);
    box-shadow: 0 6px 16px rgba(99, 102, 241, 0.4);
    transform: translateY(-1px);
}

.btn-secondary-modern {
    background: linear-gradient(135deg, #6B7280, #4B5563);
    color: white;
    box-shadow: 0 4px 12px rgba(107, 114, 128, 0.3);
}

.btn-secondary-modern:hover {
    background: linear-gradient(135deg, #4B5563, #374151);
    box-shadow: 0 6px 16px rgba(107, 114, 128, 0.4);
    transform: translateY(-1px);
}

.btn-warning-modern {
    background: linear-gradient(135deg, #F59E0B, #D97706);
    color: white;
    box-shadow: 0 4px 12px rgba(245, 158, 11, 0.3);
}

.btn-warning-modern:hover {
    background: linear-gradient(135deg, #D97706, #B45309);
    box-shadow: 0 6px 16px rgba(245, 158, 11, 0.4);
    transform: translateY(-1px);
}

.btn-icon-modern {
    font-size: 1rem;
}

/* Waiter Compact Styles */
<?php if ($isWaiter): ?>
.waiter-pos-header-compact {
    background: linear-gradient(135deg, #6366F1 0%, #4F46E5 30%, #7C3AED 60%, #EC4899 100%);
    padding: 0.875rem 1.25rem;
    border-radius: 16px;
    margin-bottom: 1rem;
    box-shadow: 0 6px 24px rgba(99, 102, 241, 0.35), 0 0 0 1px rgba(255, 255, 255, 0.1) inset;
    display: flex;
    justify-content: space-between;
    align-items: center;
    position: sticky;
    top: 0;
    z-index: 100;
    backdrop-filter: blur(10px);
    position: relative;
    overflow: hidden;
}

.waiter-pos-header-compact::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
    animation: headerShine 3s infinite;
}

@keyframes headerShine {
    0% { left: -100%; }
    100% { left: 100%; }
}

.waiter-pos-title-compact {
    position: relative;
    z-index: 1;
}

.waiter-pos-title-compact h1 {
    color: white;
    font-size: 1.5rem;
    margin: 0;
    font-weight: 800;
    display: inline-block;
    text-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
    letter-spacing: -0.5px;
}

.waiter-name {
    color: rgba(255,255,255,0.9);
    font-size: 0.875rem;
    margin-left: 0.75rem;
    font-weight: 500;
}

.waiter-pos-controls-compact {
    display: flex;
    gap: 0.5rem;
    position: relative;
    z-index: 1;
}

.btn-compact {
    background: rgba(255,255,255,0.2);
    color: white;
    border: 2px solid rgba(255,255,255,0.5);
    border-radius: 8px;
    padding: 0.5rem 0.625rem;
    font-size: 1.25rem;
    cursor: pointer;
    transition: all 0.2s;
    min-width: 60px;
    min-height: 60px;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    gap: 0.25rem;
    text-decoration: none;
}

.btn-compact:hover {
    background: white;
    color: #6366F1;
    transform: scale(1.05);
    text-decoration: none;
}

.btn-icon {
    font-size: 1.25rem;
    line-height: 1;
}

.btn-label {
    font-size: 0.625rem;
    font-weight: 600;
    line-height: 1;
    text-align: center;
    white-space: nowrap;
    letter-spacing: 0.02em;
}

.waiter-detail-container .receipt-paper {
    max-width: 80mm;
}
<?php endif; ?>

/* Print Mode - Struk Pembayaran Thermal */
@media print {
    @page {
        size: 80mm auto;
        margin: 0;
    }
    
    * {
        box-sizing: border-box;
        color: #000 !important;
        background: white !important;
    }
    
    html, body {
        width: 80mm;
        max-width: 80mm;
        margin: 0;
        padding: 0;
        background: white;
        font-family: 'Courier New', monospace;
        font-size: 10pt;
    }
    
    /* Hide unnecessary elements */
    .waiter-pos-header-compact,
    .page-header,
    .receipt-actions-modern,
    .navbar,
    .alert,
    .quick-nav,
    .btn-compact,
    .btn-modern,
    footer,
    .navbar-brand,
    .navbar-menu,
    .navbar-user,
    .offline-status-bar,
    #offline-status-bar,
    .status-indicator {
        display: none !important;
    }
    
    .container {
        width: 80mm;
        max-width: 80mm;
        margin: 0 auto;
        padding: 0;
    }
    
    .container > *:not(.transaction-detail-container) {
        display: none !important;
    }
    
    .transaction-detail-container {
        width: 80mm;
        max-width: 80mm;
        margin: 0 auto;
        padding: 0;
    }
    
    .receipt-paper {
        width: 80mm;
        max-width: 80mm;
        margin: 0 auto;
        padding: 3mm 2.5mm;
        background: white;
        page-break-inside: avoid;
        box-sizing: border-box;
    }
    
    .receipt-content {
        width: 100%;
        box-sizing: border-box;
    }
    
    .receipt-header-struk,
    .receipt-info-struk,
    .receipt-items-struk,
    .receipt-total-struk,
    .receipt-footer-struk {
        width: 100%;
        max-width: 100%;
        box-sizing: border-box;
        word-wrap: break-word;
    }
    
    .receipt-title {
        font-size: 14pt;
        font-weight: bold;
        margin-bottom: 6px;
    }
    
    .receipt-address,
    .receipt-phone {
        font-size: 9pt;
    }
    
    .receipt-line {
        font-size: 10pt;
        margin: 4px 0;
        text-align: center;
    }
    
    .receipt-line-item {
        display: flex;
        justify-content: space-between;
        font-size: 10pt;
        margin: 2px 0;
        gap: 4px;
    }
    
    .receipt-label {
        flex: 0 0 auto;
    }
    
    .receipt-value {
        text-align: right;
        flex: 1;
    }
    
    .receipt-item-row {
        display: flex;
        justify-content: space-between;
        margin: 4px 0;
        gap: 4px;
    }
    
    .receipt-item-left {
        flex: 1;
        min-width: 0;
        max-width: 70%;
    }
    
    .receipt-item-right {
        flex: 0 0 auto;
        text-align: right;
        max-width: 30%;
    }
    
    .receipt-item-name {
        font-size: 10pt;
    }
    
    .receipt-item-detail {
        font-size: 9pt;
    }
    
    .receipt-item-subtotal {
        font-size: 10pt;
        text-align: right;
    }
    
    .receipt-total-row {
        display: flex;
        justify-content: space-between;
        font-size: 11pt;
        font-weight: bold;
        margin: 4px 0;
        gap: 4px;
    }
    
    .receipt-total-label {
        flex: 0 0 auto;
    }
    
    .receipt-total-amount {
        text-align: right;
        flex: 0 0 auto;
    }
    
    .receipt-payment-row {
        display: flex;
        justify-content: space-between;
        font-size: 10pt;
        margin: 2px 0;
        gap: 4px;
    }
    
    .receipt-payment-label {
        flex: 0 0 auto;
    }
    
    .receipt-payment-value {
        text-align: right;
        flex: 0 0 auto;
    }
    
    .receipt-payment-status {
        font-size: 11pt;
        font-weight: bold;
        text-align: center;
        margin: 6px 0;
    }
    
    .receipt-payment-status.unpaid {
        font-size: 12pt;
    }
    
    .receipt-thanks {
        font-size: 11pt;
        font-weight: bold;
        text-align: center;
        margin-bottom: 3px;
    }
    
    .receipt-note {
        font-size: 8pt;
        text-align: center;
    }
}

.print-mode .waiter-pos-header-compact,
.print-mode .page-header,
.print-mode .receipt-actions-modern {
    display: none !important;
}

.print-mode .receipt-paper {
    max-width: 80mm;
    width: 80mm;
    margin: 0 auto;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.15);
}

/* Non-print mode - Show receipt in card */
.receipt-paper:not(.receipt-print) {
    background: white;
    border-radius: 0;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    border: 1px solid #e5e7eb;
    overflow: visible;
}

/* Ensure all receipt elements fit within 80mm */
.receipt-paper * {
    max-width: 100%;
    box-sizing: border-box;
}

.receipt-paper {
    overflow: visible !important;
    border-radius: 0 !important;
}

.receipt-paper * {
    border-radius: 0 !important;
}

/* Prevent text overflow */
.receipt-paper,
.receipt-content,
.receipt-header-struk,
.receipt-info-struk,
.receipt-items-struk,
.receipt-total-struk,
.receipt-footer-struk {
    word-wrap: break-word;
    overflow-wrap: break-word;
    hyphens: auto;
}

/* Force visibility for all receipt elements */
.receipt-paper,
.receipt-content,
.receipt-header-struk,
.receipt-info-struk,
.receipt-items-struk,
.receipt-total-struk,
.receipt-footer-struk,
.receipt-title,
.receipt-address,
.receipt-phone,
.receipt-line,
.receipt-line-item,
.receipt-label,
.receipt-value,
.receipt-item-row,
.receipt-item-name,
.receipt-item-detail,
.receipt-item-qty,
.receipt-item-price,
.receipt-item-subtotal,
.receipt-total-row,
.receipt-total-label,
.receipt-total-amount,
.receipt-payment-row,
.receipt-payment-label,
.receipt-payment-value,
.receipt-payment-status,
.receipt-thanks,
.receipt-note {
    display: block !important;
    visibility: visible !important;
    opacity: 1 !important;
}

.receipt-line-item,
.receipt-item-detail,
.receipt-total-row,
.receipt-payment-row {
    display: flex !important;
}

.receipt-label,
.receipt-value,
.receipt-item-qty,
.receipt-item-price,
.receipt-item-subtotal,
.receipt-total-label,
.receipt-total-amount,
.receipt-payment-label,
.receipt-payment-value {
    display: inline-block !important;
}

/* Fullscreen Mode */
body.detail-fullscreen-active .transaction-detail-container {
    max-width: 100%;
    padding: 0.5rem;
}

body.detail-fullscreen-active .navbar {
    display: none;
}

body.detail-fullscreen-active .container {
    max-width: 100%;
    margin: 0;
    padding: 0.5rem;
}

/* Responsive */
@media (max-width: 768px) {
    .info-row {
        grid-template-columns: 1fr;
    }
    
    .receipt-actions-modern {
        flex-direction: column;
        margin-top: 1.5rem;
        padding-top: 1rem;
    }
    
    .btn-modern {
        width: 100%;
        justify-content: center;
    }
    
    .receipt-items-modern thead th,
    .receipt-items-modern tbody td {
        padding: 0.5rem;
        font-size: 0.8125rem;
    }
}
</style>

<?php include __DIR__ . '/includes/footer.php'; ?>

