<?php
/**
 * Transactions List
 */
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/functions.php';

requireLogin();

$currentUser = getCurrentUser();
$isWaiter = ($currentUser['role'] == 'waiters');

$pageTitle = 'Transaksi';

$transaction = new Transaction();

$date_from = $_GET['date_from'] ?? date('Y-m-d');
$date_to = $_GET['date_to'] ?? date('Y-m-d');
$filter_payment = $_GET['filter_payment'] ?? 'all'; // all, paid, unpaid

// Get transactions based on filter
if ($filter_payment === 'unpaid') {
    $transactions = $transaction->getUnpaidTransactions($date_from, $date_to);
} else {
    $transactions = $transaction->getAll($date_from, $date_to);
    if ($filter_payment === 'paid') {
        $transactions = array_filter($transactions, function($t) {
            return ($t['payment_status'] ?? 'paid') === 'paid';
        });
    }
}

include __DIR__ . '/includes/header.php';
?>

<?php if ($isWaiter): ?>
<style>
/* Hide navbar for waiters */
body .navbar {
    display: none !important;
}

body .container {
    max-width: 100% !important;
    margin: 0 !important;
    padding: 1rem !important;
}

/* Elegant background for waiter */
body {
    background: linear-gradient(135deg, #F0F4FF 0%, #E0E7FF 30%, #F8FAFF 60%, #EDE9FE 100%) !important;
    background-attachment: fixed;
    position: relative;
}

body::before {
    content: '';
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: 
        radial-gradient(circle at 20% 50%, rgba(99, 102, 241, 0.1) 0%, transparent 50%),
        radial-gradient(circle at 80% 80%, rgba(139, 92, 246, 0.1) 0%, transparent 50%),
        radial-gradient(circle at 40% 20%, rgba(236, 72, 153, 0.05) 0%, transparent 50%);
    pointer-events: none;
    z-index: 0;
}

body > * {
    position: relative;
    z-index: 1;
}
</style>
<?php endif; ?>

<?php if ($isWaiter): ?>
<!-- Waiter Header - Compact -->
<div class="waiter-pos-header-compact">
    <div class="waiter-pos-title-compact">
        <h1>📋 Transaksi</h1>
        <span class="waiter-name"><?php echo escape($currentUser['name']); ?></span>
    </div>
    <div class="waiter-pos-controls-compact">
        <a href="<?php echo BASE_URL; ?>public/dashboard.php" class="btn-compact btn-dashboard" title="Kembali ke Dashboard">
            <span class="btn-icon">🏠</span>
            <span class="btn-label">Dashboard</span>
        </a>
        <a href="<?php echo BASE_URL; ?>public/pos.php" class="btn-compact btn-pos" title="POS">
            <span class="btn-icon">💰</span>
            <span class="btn-label">POS</span>
        </a>
        <a href="<?php echo BASE_URL; ?>public/waiter.php" class="btn-compact btn-waiter" title="Waiter">
            <span class="btn-icon">🍽️</span>
            <span class="btn-label">Waiter</span>
        </a>
        <?php if (in_array($currentUser['role'], ['dapur', 'waiters', 'manager', 'admin'])): ?>
        <a href="<?php echo BASE_URL; ?>public/kitchen.php" class="btn-compact btn-kitchen" title="Dapur">
            <span class="btn-icon">🏪</span>
            <span class="btn-label">Dapur</span>
        </a>
        <?php endif; ?>
        <button class="btn-compact btn-refresh" onclick="location.reload()" title="Refresh">
            <span class="btn-icon">🔄</span>
            <span class="btn-label">Refresh</span>
        </button>
        <button class="btn-compact btn-fullscreen" id="fullscreenBtn" onclick="toggleFullscreen()" title="Fullscreen">
            <span class="btn-icon" id="fullscreenIcon">⛶</span>
            <span class="btn-label">Fullscreen</span>
        </button>
    </div>
</div>
<?php else: ?>
<div class="page-header">
    <h1>📋 Daftar Transaksi</h1>
    <div class="quick-nav">
        <a href="<?php echo BASE_URL; ?>public/dashboard.php" class="quick-nav-btn" title="Dashboard">
            <span class="quick-nav-icon">🏠</span>
            <span class="quick-nav-label">Dashboard</span>
        </a>
        <a href="<?php echo BASE_URL; ?>public/pos.php" class="quick-nav-btn" title="POS">
            <span class="quick-nav-icon">💰</span>
            <span class="quick-nav-label">POS</span>
        </a>
        <?php if (in_array($currentUser['role'], ['dapur', 'waiters', 'manager', 'admin'])): ?>
        <a href="<?php echo BASE_URL; ?>public/kitchen.php" class="quick-nav-btn" title="Dapur">
            <span class="quick-nav-icon">🏪</span>
            <span class="quick-nav-label">Dapur</span>
        </a>
        <?php endif; ?>
        <?php if (in_array($currentUser['role'], ['waiters', 'manager', 'admin'])): ?>
        <a href="<?php echo BASE_URL; ?>public/waiter.php" class="quick-nav-btn" title="Waiter">
            <span class="quick-nav-icon">🍽️</span>
            <span class="quick-nav-label">Waiter</span>
        </a>
        <?php endif; ?>
        <button class="quick-nav-btn" onclick="location.reload()" title="Refresh">
            <span class="quick-nav-icon">🔄</span>
            <span class="quick-nav-label">Refresh</span>
        </button>
        <button class="quick-nav-btn" id="fullscreenBtn" onclick="toggleFullscreen()" title="Fullscreen">
            <span class="quick-nav-icon" id="fullscreenIcon">⛶</span>
            <span class="quick-nav-label">Fullscreen</span>
        </button>
    </div>
</div>
<?php endif; ?>

<div class="transactions-container <?php echo $isWaiter ? 'waiter-transactions-container' : ''; ?>">
    <!-- Compact Filter -->
    <div class="card <?php echo $isWaiter ? 'waiter-card-compact' : ''; ?> filter-card-compact">
        <div class="card-body <?php echo $isWaiter ? 'waiter-card-body-compact' : ''; ?>">
            <form method="GET" class="filter-form-compact-inline">
                <div class="filter-row-inline">
                    <input type="date" name="date_from" value="<?php echo escape($date_from); ?>" class="form-input-compact" title="Dari Tanggal">
                    <input type="date" name="date_to" value="<?php echo escape($date_to); ?>" class="form-input-compact" title="Sampai Tanggal">
                    <select name="filter_payment" class="form-input-compact">
                        <option value="all" <?php echo $filter_payment === 'all' ? 'selected' : ''; ?>>Semua Status</option>
                        <option value="paid" <?php echo $filter_payment === 'paid' ? 'selected' : ''; ?>>Sudah Dibayar</option>
                        <option value="unpaid" <?php echo $filter_payment === 'unpaid' ? 'selected' : ''; ?>>Belum Dibayar</option>
                    </select>
                    <button type="submit" class="btn-filter-compact">🔍 Filter</button>
                    <a href="<?php echo BASE_URL; ?>public/transactions.php" class="btn-reset-compact">🔄</a>
                </div>
            </form>
        </div>
    </div>

    <!-- Compact Table -->
    <div class="card <?php echo $isWaiter ? 'waiter-card-compact' : ''; ?>">
        <div class="card-header <?php echo $isWaiter ? 'waiter-card-header-compact' : ''; ?>">
            <h2>📊 Transaksi</h2>
        </div>
        <div class="card-body <?php echo $isWaiter ? 'waiter-card-body-compact' : ''; ?>">
            <div class="table-responsive-modern">
                <table class="table-modern table-compact">
                    <thead>
                        <tr>
                            <th>Invoice</th>
                            <th>Kasir</th>
                            <th>Total</th>
                            <th>Metode</th>
                            <th>Status</th>
                            <th>Tanggal</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($transactions)): ?>
                            <tr>
                                <td colspan="7" class="text-center-empty">
                                    <div class="empty-state">
                                        <span class="empty-icon">📭</span>
                                        <p>Tidak ada transaksi</p>
                                    </div>
                                </td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($transactions as $t): 
                                $payment_status = $t['payment_status'] ?? 'paid';
                            ?>
                                <tr class="table-row-modern <?php echo $payment_status === 'unpaid' ? 'row-unpaid' : ''; ?>">
                                    <td><strong class="invoice-number-compact"><?php echo escape($t['invoice_number']); ?></strong></td>
                                    <td><span class="cashier-name-compact"><?php echo escape($t['cashier_name']); ?></span></td>
                                    <td><span class="total-amount-compact"><?php echo formatCurrency($t['total']); ?></span></td>
                                    <td><span class="badge-compact badge-payment-compact"><?php echo escape($t['payment_method']); ?></span></td>
                                    <td>
                                        <?php if ($payment_status === 'paid'): ?>
                                            <span class="badge-compact badge-success-compact">✓ Lunas</span>
                                        <?php else: ?>
                                            <span class="badge-compact badge-warning-compact">⏳ Belum</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><span class="date-text-compact"><?php echo formatDate($t['created_at']); ?></span></td>
                                    <td>
                                        <div class="action-buttons-compact">
                                            <a href="<?php echo BASE_URL; ?>public/transaction_detail.php?id=<?php echo $t['id']; ?>" class="btn-action-compact btn-detail-compact" title="Detail">👁️</a>
                                            <?php if ($payment_status === 'unpaid'): ?>
                                                <a href="<?php echo BASE_URL; ?>public/payment.php?id=<?php echo $t['id']; ?>" class="btn-action-compact btn-pay-compact" title="Bayar">💳</a>
                                            <?php else: ?>
                                                <button onclick="printReceipt(<?php echo $t['id']; ?>)" class="btn-action-compact btn-print-compact" title="Cetak">🖨️</button>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script>
function printReceipt(id) {
    window.open('<?php echo BASE_URL; ?>public/transaction_detail.php?id=' + id + '&print=1', '_blank');
}

// Enter fullscreen function
function enterFullscreen() {
    const elem = document.documentElement;
    
    if (!document.fullscreenElement && !document.webkitFullscreenElement && 
        !document.mozFullScreenElement && !document.msFullscreenElement) {
        // Try to enter fullscreen
        const promise = elem.requestFullscreen ? elem.requestFullscreen() :
                       elem.webkitRequestFullscreen ? elem.webkitRequestFullscreen() :
                       elem.mozRequestFullScreen ? elem.mozRequestFullScreen() :
                       elem.msRequestFullscreen ? elem.msRequestFullscreen() : null;
        
        if (promise) {
            promise.then(() => {
                // Fullscreen successful, update button state
                updateFullscreenButton();
            }).catch(err => {
                // Fullscreen failed (may require user interaction in some browsers)
                console.log('Fullscreen request failed:', err);
            });
        }
    }
}

// Exit fullscreen function
function exitFullscreen() {
    if (document.exitFullscreen) {
        document.exitFullscreen();
    } else if (document.webkitExitFullscreen) {
        document.webkitExitFullscreen();
    } else if (document.mozCancelFullScreen) {
        document.mozCancelFullScreen();
    } else if (document.msExitFullscreen) {
        document.msExitFullscreen();
    }
}

// Fullscreen functionality
function toggleFullscreen() {
    const elem = document.documentElement;
    const fullscreenBtn = document.getElementById('fullscreenBtn');
    const fullscreenIcon = document.getElementById('fullscreenIcon');
    
    if (!document.fullscreenElement && !document.webkitFullscreenElement && 
        !document.mozFullScreenElement && !document.msFullscreenElement) {
        // Enter fullscreen
        enterFullscreen();
        
        if (fullscreenIcon) fullscreenIcon.textContent = '⛶';
        document.body.classList.add('transactions-fullscreen-active');
    } else {
        // Exit fullscreen
        exitFullscreen();
        
        if (fullscreenIcon) fullscreenIcon.textContent = '⛶';
        document.body.classList.remove('transactions-fullscreen-active');
    }
}

// Listen for fullscreen changes
document.addEventListener('fullscreenchange', updateFullscreenButton);
document.addEventListener('webkitfullscreenchange', updateFullscreenButton);
document.addEventListener('mozfullscreenchange', updateFullscreenButton);
document.addEventListener('MSFullscreenChange', updateFullscreenButton);

function updateFullscreenButton() {
    const isFullscreen = !!(document.fullscreenElement || document.webkitFullscreenElement || 
                            document.mozFullScreenElement || document.msFullscreenElement);
    const fullscreenIcon = document.getElementById('fullscreenIcon');
    
    if (isFullscreen) {
        if (fullscreenIcon) fullscreenIcon.textContent = '⛶';
        document.body.classList.add('transactions-fullscreen-active');
    } else {
        if (fullscreenIcon) fullscreenIcon.textContent = '⛶';
        document.body.classList.remove('transactions-fullscreen-active');
    }
}

// Keyboard shortcut for fullscreen (F11)
document.addEventListener('keydown', function(e) {
    if (e.key === 'F11') {
        e.preventDefault();
        toggleFullscreen();
    }
});
</script>

<style>
/* Page Header with Quick Nav */
.page-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 1rem;
    flex-wrap: wrap;
    gap: 1rem;
}

.page-header h1 {
    margin: 0;
    flex: 1;
}

.quick-nav {
    display: flex;
    gap: 0.5rem;
    flex-wrap: wrap;
}

.quick-nav-btn {
    display: inline-flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    gap: 0.25rem;
    padding: 0.5rem 0.75rem;
    background: linear-gradient(135deg, #6366F1, #4F46E5);
    color: white;
    border: none;
    border-radius: 8px;
    text-decoration: none;
    transition: all 0.2s;
    min-width: 60px;
    min-height: 60px;
    box-shadow: 0 2px 6px rgba(99, 102, 241, 0.3);
    cursor: pointer;
    font-family: inherit;
}

.quick-nav-btn:hover {
    background: linear-gradient(135deg, #4F46E5, #7C3AED);
    box-shadow: 0 4px 12px rgba(99, 102, 241, 0.4);
    transform: translateY(-2px);
    text-decoration: none;
    color: white;
}

.quick-nav-icon {
    font-size: 1.25rem;
    line-height: 1;
}

.quick-nav-label {
    font-size: 0.625rem;
    font-weight: 600;
    line-height: 1;
    text-align: center;
    white-space: nowrap;
}

/* Compact Transactions Page Styling */
.transactions-container {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.waiter-transactions-container {
    gap: 0.75rem;
}

/* Compact Filter Card */
.filter-card-compact .card-body {
    padding: 0.75rem 1rem;
}

.filter-form-compact-inline {
    margin: 0;
}

.filter-row-inline {
    display: flex;
    gap: 0.5rem;
    align-items: center;
    flex-wrap: wrap;
}

.form-input-compact {
    padding: 0.5rem 0.75rem;
    border: 1.5px solid #E0E7FF;
    border-radius: 6px;
    font-size: 0.8125rem;
    transition: all 0.2s;
    background: #F8FAFF;
    font-weight: 500;
    min-width: 140px;
    flex: 1;
}

.form-input-compact:focus {
    outline: none;
    border-color: #6366F1;
    box-shadow: 0 0 0 2px rgba(99, 102, 241, 0.1);
    background: white;
}

.btn-filter-compact {
    padding: 0.5rem 1rem;
    border: none;
    border-radius: 6px;
    font-weight: 600;
    font-size: 0.8125rem;
    cursor: pointer;
    transition: all 0.2s;
    background: linear-gradient(135deg, #6366F1, #4F46E5);
    color: white;
    box-shadow: 0 2px 6px rgba(99, 102, 241, 0.3);
    white-space: nowrap;
}

.btn-filter-compact:hover {
    background: linear-gradient(135deg, #4F46E5, #7C3AED);
    box-shadow: 0 3px 8px rgba(99, 102, 241, 0.4);
    transform: translateY(-1px);
}

.btn-reset-compact {
    padding: 0.5rem;
    border: none;
    border-radius: 6px;
    font-size: 1rem;
    cursor: pointer;
    transition: all 0.2s;
    background: #E5E7EB;
    color: #6B7280;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    min-width: 36px;
    min-height: 36px;
}

.btn-reset-compact:hover {
    background: #D1D5DB;
    color: #374151;
    transform: scale(1.05);
}

/* Compact Table */
.table-responsive-modern {
    overflow-x: auto;
    -webkit-overflow-scrolling: touch;
}

.table-modern {
    width: 100%;
    border-collapse: collapse;
    background: white;
}

.table-modern.table-compact thead {
    background: linear-gradient(135deg, #6366F1 0%, #4F46E5 50%, #7C3AED 100%);
    color: white;
}

.table-modern.table-compact thead th {
    padding: 0.625rem 0.75rem;
    text-align: left;
    font-weight: 600;
    font-size: 0.75rem;
    text-transform: uppercase;
    letter-spacing: 0.3px;
    white-space: nowrap;
}

.table-modern.table-compact tbody tr {
    border-bottom: 1px solid #E5E7EB;
    transition: all 0.15s;
}

.table-modern.table-compact tbody tr:hover {
    background: #F8FAFF;
}

.table-modern.table-compact tbody tr.row-unpaid {
    background: #FEF3C7;
}

.table-modern.table-compact tbody tr.row-unpaid:hover {
    background: #FDE68A;
}

.table-modern.table-compact tbody td {
    padding: 0.625rem 0.75rem;
    font-size: 0.8125rem;
    vertical-align: middle;
}

.text-center-empty {
    text-align: center;
    padding: 2rem !important;
}

.empty-state {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 0.75rem;
    color: #9CA3AF;
}

.empty-icon {
    font-size: 2.5rem;
}

.empty-state p {
    font-size: 1rem;
    font-weight: 500;
}

/* Compact Cell Styling */
.invoice-number-compact {
    color: #1F2937;
    font-size: 0.875rem;
    font-weight: 700;
}

.cashier-name-compact {
    color: #4B5563;
    font-weight: 500;
    font-size: 0.8125rem;
}

.total-amount-compact {
    color: #6366F1;
    font-weight: 700;
    font-size: 0.875rem;
}

.date-text-compact {
    color: #6B7280;
    font-size: 0.75rem;
}

/* Compact Badges */
.badge-compact {
    display: inline-block;
    padding: 0.25rem 0.5rem;
    border-radius: 4px;
    font-size: 0.6875rem;
    font-weight: 600;
    white-space: nowrap;
}

.badge-payment-compact {
    background: #E0E7FF;
    color: #4F46E5;
    border: 1px solid #C7D2FE;
}

.badge-success-compact {
    background: #D1FAE5;
    color: #059669;
    border: 1px solid #6EE7B7;
}

.badge-warning-compact {
    background: #FEF3C7;
    color: #D97706;
    border: 1px solid #FCD34D;
}

/* Compact Action Buttons */
.action-buttons-compact {
    display: flex;
    gap: 0.375rem;
    align-items: center;
}

.btn-action-compact {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    padding: 0.375rem;
    border: none;
    border-radius: 4px;
    font-size: 1rem;
    cursor: pointer;
    transition: all 0.15s;
    text-decoration: none;
    min-width: 32px;
    min-height: 32px;
    line-height: 1;
}

.btn-detail-compact {
    background: #6366F1;
    color: white;
}

.btn-detail-compact:hover {
    background: #4F46E5;
    transform: scale(1.1);
}

.btn-pay-compact {
    background: #F59E0B;
    color: white;
}

.btn-pay-compact:hover {
    background: #D97706;
    transform: scale(1.1);
}

.btn-print-compact {
    background: #10B981;
    color: white;
}

.btn-print-compact:hover {
    background: #059669;
    transform: scale(1.1);
}

/* Waiter Compact Styles */
<?php if ($isWaiter): ?>
.waiter-pos-header-compact {
    background: linear-gradient(135deg, #6366F1 0%, #4F46E5 30%, #7C3AED 60%, #EC4899 100%);
    padding: 0.875rem 1.25rem;
    border-radius: 16px;
    margin-bottom: 1rem;
    box-shadow: 0 6px 24px rgba(99, 102, 241, 0.35), 0 0 0 1px rgba(255, 255, 255, 0.1) inset;
    display: flex;
    justify-content: space-between;
    align-items: center;
    position: sticky;
    top: 0;
    z-index: 100;
    backdrop-filter: blur(10px);
    position: relative;
    overflow: hidden;
}

.waiter-pos-header-compact::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
    animation: headerShine 3s infinite;
}

@keyframes headerShine {
    0% {
        left: -100%;
    }
    100% {
        left: 100%;
    }
}

.waiter-pos-title-compact {
    position: relative;
    z-index: 1;
}

.waiter-pos-title-compact h1 {
    color: white;
    font-size: 1.5rem;
    margin: 0;
    font-weight: 800;
    display: inline-block;
    text-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
    letter-spacing: -0.5px;
}

.waiter-name {
    color: rgba(255,255,255,0.9);
    font-size: 0.875rem;
    margin-left: 0.75rem;
    font-weight: 500;
}

.waiter-pos-controls-compact {
    display: flex;
    gap: 0.5rem;
    position: relative;
    z-index: 1;
}

.btn-compact {
    background: rgba(255,255,255,0.2);
    color: white;
    border: 2px solid rgba(255,255,255,0.5);
    border-radius: 8px;
    padding: 0.5rem 0.625rem;
    font-size: 1.25rem;
    cursor: pointer;
    transition: all 0.2s;
    min-width: 60px;
    min-height: 60px;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    gap: 0.25rem;
    text-decoration: none;
}

.btn-compact:hover {
    background: white;
    color: #6366F1;
    transform: scale(1.05);
    text-decoration: none;
}

.btn-icon {
    font-size: 1.25rem;
    line-height: 1;
    display: flex;
    align-items: center;
    justify-content: center;
}

.btn-label {
    font-size: 0.625rem;
    font-weight: 600;
    line-height: 1;
    text-align: center;
    white-space: nowrap;
    letter-spacing: 0.02em;
}

.waiter-card-compact {
    border-radius: 12px;
    box-shadow: 0 2px 8px rgba(99, 102, 241, 0.15);
}

.waiter-card-header-compact {
    background: linear-gradient(135deg, #6366F1 0%, #4F46E5 50%, #7C3AED 100%);
    color: white;
    padding: 0.625rem 0.75rem;
}

.waiter-card-header-compact h2 {
    margin: 0;
    font-size: 0.9375rem;
    font-weight: 600;
}

.waiter-card-body-compact {
    padding: 0.75rem;
}

.filter-card-compact .waiter-card-body-compact {
    padding: 0.5rem 0.75rem;
}
<?php endif; ?>

/* Fullscreen Mode */
body.transactions-fullscreen-active .transactions-container {
    max-width: 100%;
    padding: 0.5rem;
}

body.transactions-fullscreen-active .navbar {
    display: none;
}

body.transactions-fullscreen-active .container {
    max-width: 100%;
    margin: 0;
    padding: 0.5rem;
}

body.transactions-fullscreen-active .waiter-pos-header-compact,
body.transactions-fullscreen-active .page-header {
    margin-bottom: 0.75rem;
    padding: 0.625rem 0.875rem;
}

/* Responsive Design */
@media (max-width: 768px) {
    .page-header {
        flex-direction: column;
        align-items: flex-start;
    }
    
    .quick-nav {
        width: 100%;
        justify-content: flex-start;
    }
    
    .quick-nav-btn {
        min-width: 50px;
        min-height: 50px;
        padding: 0.375rem 0.5rem;
    }
    
    .quick-nav-icon {
        font-size: 1rem;
    }
    
    .quick-nav-label {
        font-size: 0.5625rem;
    }
    
    .filter-row-inline {
        flex-direction: column;
    }
    
    .form-input-compact {
        width: 100%;
        min-width: 100%;
    }
    
    .btn-filter-compact,
    .btn-reset-compact {
        width: 100%;
    }
    
    .table-modern.table-compact thead th,
    .table-modern.table-compact tbody td {
        padding: 0.5rem;
        font-size: 0.75rem;
    }
    
    .action-buttons-compact {
        flex-direction: column;
        width: 100%;
    }
    
    .btn-action-compact {
        width: 100%;
    }
}
</style>

<?php include __DIR__ . '/includes/footer.php'; ?>

