<?php
/**
 * Database Update Script
 * Run this to update existing database to support waiters and dapur roles
 */

// Hash function
function hashPassword($password) {
    return hash('sha256', $password . 'pos_salt_2024');
}

// Connect to database
$host = 'localhost';
$username = 'root';
$password = '';
$db_name = 'pos_coffee';

$conn = new mysqli($host, $username, $password, $db_name);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

echo "<h2>Updating Database...</h2>";

// Update users table to add new roles
$sql = "ALTER TABLE users MODIFY COLUMN role ENUM('admin', 'manager', 'cashier', 'waiters', 'dapur') DEFAULT 'cashier'";
if ($conn->query($sql)) {
    echo "<p style='color:green'>✓ Role ENUM updated successfully</p>";
} else {
    $error = $conn->error;
    // Check if error is because it's already updated or different issue
    if (strpos($error, 'Duplicate') === false && strpos($error, 'already exists') === false) {
        // Try to check current ENUM values
        $check_sql = "SHOW COLUMNS FROM users LIKE 'role'";
        $result = $conn->query($check_sql);
        if ($result && $row = $result->fetch_assoc()) {
            $enum_str = $row['Type'];
            if (strpos($enum_str, 'waiters') !== false && strpos($enum_str, 'dapur') !== false) {
                echo "<p style='color:blue'>ℹ Role ENUM sudah termasuk waiters dan dapur</p>";
            } else {
                echo "<p style='color:red'>✗ Error updating Role ENUM: " . htmlspecialchars($error) . "</p>";
                echo "<p style='color:orange'>Current ENUM values: " . htmlspecialchars($enum_str) . "</p>";
            }
        } else {
            echo "<p style='color:orange'>⚠ Role ENUM update: " . htmlspecialchars($error) . "</p>";
        }
    }
}

// Create waiters user if not exists
$username = 'waiters';
$check_stmt = $conn->prepare("SELECT id FROM users WHERE username = ?");
$check_stmt->bind_param("s", $username);
$check_stmt->execute();
$result = $check_stmt->get_result();

if ($result->num_rows == 0) {
    $hashed_password = hashPassword('waiters123');
    $name = 'Waiter 1';
    $role = 'waiters';
    $stmt = $conn->prepare("INSERT INTO users (username, password, name, role) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("ssss", $username, $hashed_password, $name, $role);
    if ($stmt->execute()) {
        echo "<p style='color:green'>✓ Waiters user created</p>";
    } else {
        echo "<p style='color:red'>✗ Error creating waiters user: " . $stmt->error . "</p>";
    }
} else {
    echo "<p style='color:blue'>ℹ Waiters user already exists</p>";
}

// Create dapur user if not exists
$username = 'dapur';
$check_stmt = $conn->prepare("SELECT id FROM users WHERE username = ?");
$check_stmt->bind_param("s", $username);
$check_stmt->execute();
$result = $check_stmt->get_result();

if ($result->num_rows == 0) {
    $hashed_password = hashPassword('dapur123');
    $name = 'Staff Dapur';
    $role = 'dapur';
    $stmt = $conn->prepare("INSERT INTO users (username, password, name, role) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("ssss", $username, $hashed_password, $name, $role);
    if ($stmt->execute()) {
        echo "<p style='color:green'>✓ Dapur user created</p>";
    } else {
        echo "<p style='color:red'>✗ Error creating dapur user: " . $stmt->error . "</p>";
    }
} else {
    echo "<p style='color:blue'>ℹ Dapur user already exists</p>";
}

// Update transaction_items to add status column
$check_column = $conn->query("SHOW COLUMNS FROM transaction_items LIKE 'status'");
if ($check_column->num_rows == 0) {
    $sql = "ALTER TABLE transaction_items ADD COLUMN status ENUM('pending', 'preparing', 'ready', 'completed') DEFAULT 'pending' AFTER subtotal";
    if ($conn->query($sql)) {
        echo "<p style='color:green'>✓ Added status column to transaction_items</p>";
        // Update existing items
        $conn->query("UPDATE transaction_items SET status = 'pending' WHERE status IS NULL");
    } else {
        echo "<p style='color:orange'>⚠ Status column: " . $conn->error . "</p>";
    }
} else {
    echo "<p style='color:blue'>ℹ Status column already exists</p>";
}

// Update transaction_items to add completed_at column
$check_column = $conn->query("SHOW COLUMNS FROM transaction_items LIKE 'completed_at'");
if ($check_column->num_rows == 0) {
    $sql = "ALTER TABLE transaction_items ADD COLUMN completed_at DATETIME NULL AFTER status";
    if ($conn->query($sql)) {
        echo "<p style='color:green'>✓ Added completed_at column to transaction_items</p>";
    } else {
        echo "<p style='color:orange'>⚠ Completed_at column: " . $conn->error . "</p>";
    }
} else {
    echo "<p style='color:blue'>ℹ Completed_at column already exists</p>";
}

$conn->close();

echo "<hr>";
echo "<h3>Update Complete!</h3>";
echo "<p><a href='public/users.php'>Go to User Management</a> | ";
echo "<a href='public/kitchen.php'>Go to Kitchen</a></p>";
?>

