<?php
/**
 * Database Update Script for Merge Tables Feature
 * Run this to add merge tables functionality
 */

// Connect to database
$host = 'localhost';
$username = 'root';
$password = '';
$db_name = 'pos_coffee';

$conn = new mysqli($host, $username, $password, $db_name);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

echo "<h2>Updating Database for Merge Tables Feature...</h2>";
echo "<style>
    body { font-family: Arial, sans-serif; padding: 20px; }
    p { margin: 5px 0; }
</style>";

// Create transaction_tables junction table
$check_table = $conn->query("SHOW TABLES LIKE 'transaction_tables'");
if ($check_table->num_rows == 0) {
    $sql = "CREATE TABLE transaction_tables (
        id INT AUTO_INCREMENT PRIMARY KEY,
        transaction_id INT NOT NULL,
        table_id INT NOT NULL,
        is_primary BOOLEAN DEFAULT FALSE,
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (transaction_id) REFERENCES transactions(id) ON DELETE CASCADE,
        FOREIGN KEY (table_id) REFERENCES tables(id) ON DELETE CASCADE,
        UNIQUE KEY unique_transaction_table (transaction_id, table_id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    
    if ($conn->query($sql)) {
        echo "<p style='color:green'>✓ transaction_tables table created successfully</p>";
        
        // Migrate existing table_id to transaction_tables
        $migrate_sql = "INSERT INTO transaction_tables (transaction_id, table_id, is_primary)
            SELECT id, table_id, TRUE
            FROM transactions
            WHERE table_id IS NOT NULL
            AND NOT EXISTS (
                SELECT 1 FROM transaction_tables tt 
                WHERE tt.transaction_id = transactions.id AND tt.table_id = transactions.table_id
            )";
        
        if ($conn->query($migrate_sql)) {
            $affected = $conn->affected_rows;
            echo "<p style='color:green'>✓ Migrated {$affected} existing table relationships</p>";
        } else {
            echo "<p style='color:orange'>⚠ Migration: " . htmlspecialchars($conn->error) . "</p>";
        }
    } else {
        echo "<p style='color:red'>✗ Error creating transaction_tables table: " . htmlspecialchars($conn->error) . "</p>";
    }
} else {
    echo "<p style='color:blue'>ℹ transaction_tables table already exists</p>";
}

$conn->close();

echo "<hr>";
echo "<h3>Update Complete!</h3>";
echo "<p><a href='public/tables.php'>Go to Table Management</a> | ";
echo "<a href='public/pos.php'>Go to POS</a></p>";
?>






