<?php
/**
 * Update Database - Add payment_status field
 * Run this script once to update your database schema
 */

require_once __DIR__ . '/config/database.php';

$database = new Database();
$conn = $database->getConnection();

echo "Updating database schema...\n";

try {
    // Check if payment_status column exists
    $check = $conn->query("SHOW COLUMNS FROM transactions LIKE 'payment_status'");
    if ($check->num_rows > 0) {
        echo "✓ payment_status column already exists\n";
    } else {
        // Add payment_status column
        $sql = "ALTER TABLE transactions 
                ADD COLUMN payment_status ENUM('unpaid', 'paid') DEFAULT 'paid' AFTER status";
        $conn->query($sql);
        echo "✓ Added payment_status column\n";
        
        // Update existing transactions to be marked as paid
        $conn->query("UPDATE transactions SET payment_status = 'paid' WHERE payment_status IS NULL OR payment_status = ''");
        echo "✓ Updated existing transactions to 'paid'\n";
    }
    
    // Check if paid_at column exists
    $check = $conn->query("SHOW COLUMNS FROM transactions LIKE 'paid_at'");
    if ($check->num_rows > 0) {
        echo "✓ paid_at column already exists\n";
    } else {
        // Add paid_at column
        $sql = "ALTER TABLE transactions 
                ADD COLUMN paid_at DATETIME NULL AFTER payment_status";
        $conn->query($sql);
        echo "✓ Added paid_at column\n";
        
        // Update existing paid transactions to have paid_at = created_at
        $conn->query("UPDATE transactions SET paid_at = created_at WHERE payment_status = 'paid' AND paid_at IS NULL");
        echo "✓ Updated existing paid transactions with paid_at timestamp\n";
    }
    
    echo "\n✅ Database update completed successfully!\n";
    echo "You can now use the 'Bayar Nanti' feature.\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    exit(1);
}

$conn->close();
?>






