<?php
/**
 * Database Update Script for Table Management
 * Run this to add table management system to existing database
 */

// Connect to database
$host = 'localhost';
$username = 'root';
$password = '';
$db_name = 'pos_coffee';

$conn = new mysqli($host, $username, $password, $db_name);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

echo "<h2>Updating Database for Table Management...</h2>";
echo "<style>
    body { font-family: Arial, sans-serif; padding: 20px; }
    p { margin: 5px 0; }
</style>";

// Create tables table
$check_table = $conn->query("SHOW TABLES LIKE 'tables'");
if ($check_table->num_rows == 0) {
    $sql = "CREATE TABLE tables (
        id INT AUTO_INCREMENT PRIMARY KEY,
        name VARCHAR(50) NOT NULL,
        capacity INT DEFAULT 4,
        status ENUM('available', 'occupied', 'reserved', 'cleaning') DEFAULT 'available',
        location VARCHAR(100) DEFAULT NULL,
        notes TEXT DEFAULT NULL,
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        UNIQUE KEY unique_table_name (name)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    
    if ($conn->query($sql)) {
        echo "<p style='color:green'>✓ Tables table created successfully</p>";
        
        // Insert sample tables
        $sample_tables = [
            ['Meja 1', 2, 'Area Depan', 'available'],
            ['Meja 2', 4, 'Area Depan', 'available'],
            ['Meja 3', 4, 'Area Tengah', 'available'],
            ['Meja 4', 6, 'Area Tengah', 'available'],
            ['Meja 5', 2, 'Area Belakang', 'available'],
            ['Meja 6', 4, 'Area Belakang', 'available'],
            ['Meja 7', 8, 'Area VIP', 'available'],
            ['Meja 8', 4, 'Area VIP', 'available']
        ];
        
        $stmt = $conn->prepare("INSERT INTO tables (name, capacity, location, status) VALUES (?, ?, ?, ?)");
        foreach ($sample_tables as $tbl) {
            $stmt->bind_param("siss", $tbl[0], $tbl[1], $tbl[2], $tbl[3]);
            $stmt->execute();
        }
        $stmt->close();
        echo "<p style='color:green'>✓ Sample tables inserted</p>";
    } else {
        echo "<p style='color:red'>✗ Error creating tables table: " . htmlspecialchars($conn->error) . "</p>";
    }
} else {
    echo "<p style='color:blue'>ℹ Tables table already exists</p>";
}

// Add table_id to transactions table
$check_column = $conn->query("SHOW COLUMNS FROM transactions LIKE 'table_id'");
if ($check_column->num_rows == 0) {
    // Check if foreign key constraint exists
    $check_fk = $conn->query("SELECT CONSTRAINT_NAME 
        FROM information_schema.KEY_COLUMN_USAGE 
        WHERE TABLE_SCHEMA = '$db_name' 
        AND TABLE_NAME = 'transactions' 
        AND COLUMN_NAME = 'table_id'");
    
    $sql = "ALTER TABLE transactions ADD COLUMN table_id INT NULL AFTER user_id";
    if ($conn->query($sql)) {
        echo "<p style='color:green'>✓ Added table_id column to transactions table</p>";
        
        // Add foreign key constraint
        $fk_sql = "ALTER TABLE transactions 
            ADD CONSTRAINT fk_transactions_table 
            FOREIGN KEY (table_id) REFERENCES tables(id) ON DELETE SET NULL";
        
        if ($conn->query($fk_sql)) {
            echo "<p style='color:green'>✓ Added foreign key constraint</p>";
        } else {
            // Foreign key might already exist or tables table doesn't exist yet
            if (strpos($conn->error, 'Duplicate') === false) {
                echo "<p style='color:orange'>⚠ Foreign key constraint: " . htmlspecialchars($conn->error) . "</p>";
            } else {
                echo "<p style='color:blue'>ℹ Foreign key constraint already exists</p>";
            }
        }
    } else {
        echo "<p style='color:red'>✗ Error adding table_id column: " . htmlspecialchars($conn->error) . "</p>";
    }
} else {
    echo "<p style='color:blue'>ℹ table_id column already exists in transactions table</p>";
}

$conn->close();

echo "<hr>";
echo "<h3>Update Complete!</h3>";
echo "<p><a href='public/tables.php'>Go to Table Management</a> | ";
echo "<a href='public/waiter.php'>Go to Waiter View</a> | ";
echo "<a href='public/pos.php'>Go to POS</a></p>";
?>






